/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.proxy;

import java.lang.ref.WeakReference;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.NodeException;

public class PageTemplateWeakReference {
    private PageManager pageManager;
    private String path;
    private volatile WeakReference<PageTemplate> referentPageTemplate;

    public PageTemplateWeakReference(PageManager pageManager, PageTemplate pageTemplate) {
        this.pageManager = pageManager;
        this.path = pageTemplate.getPath();
        this.referentPageTemplate = new WeakReference<PageTemplate>(pageTemplate);
    }

    public PageTemplate getPageTemplate() {
        PageTemplate pageTemplate = (PageTemplate)this.referentPageTemplate.get();
        if (pageTemplate != null && !pageTemplate.isStale()) {
            return pageTemplate;
        }
        try {
            this.referentPageTemplate = new WeakReference<PageTemplate>(this.pageManager.getPageTemplate(this.path));
            return (PageTemplate)this.referentPageTemplate.get();
        }
        catch (PageNotFoundException pnfe) {
            throw new RuntimeException("PageTemplate " + this.path + " has been removed: " + (Object)((Object)pnfe), pnfe);
        }
        catch (NodeException ne) {
            throw new RuntimeException("PageTemplate " + this.path + " can not be accessed: " + (Object)((Object)ne), ne);
        }
    }
}

