/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.proxy;

import java.lang.ref.WeakReference;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.NodeException;

public class PageWeakReference {
    private PageManager pageManager;
    private String path;
    private volatile WeakReference<Page> referentPage;

    public PageWeakReference(PageManager pageManager, Page page) {
        this.pageManager = pageManager;
        this.path = page.getPath();
        this.referentPage = new WeakReference<Page>(page);
    }

    public Page getPage() {
        Page page = (Page)this.referentPage.get();
        if (page != null && !page.isStale()) {
            return page;
        }
        try {
            this.referentPage = new WeakReference<Page>(this.pageManager.getPage(this.path));
            return (Page)this.referentPage.get();
        }
        catch (PageNotFoundException pnfe) {
            throw new RuntimeException("Page " + this.path + " has been removed: " + (Object)((Object)pnfe), pnfe);
        }
        catch (NodeException ne) {
            throw new RuntimeException("Page " + this.path + " can not be accessed: " + (Object)((Object)ne), ne);
        }
    }
}

