/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document.proxy;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.portalsite.view.SearchPathsSiteView;
import org.apache.jetspeed.portalsite.view.SearchPathsSiteViewProxy;
import org.apache.jetspeed.portalsite.view.SiteViewMenuDefinitionLocator;
import org.apache.jetspeed.portalsite.view.SiteViewUtils;

public abstract class NodeProxy
extends SearchPathsSiteViewProxy {
    private static final String URL_ENCODING = "ISO-8859-1";
    protected static final Method EQUALS_METHOD = NodeProxy.reflectMethod(Object.class, "equals", new Class[]{Object.class});
    protected static final Method GET_PARENT_METHOD = NodeProxy.reflectMethod(Node.class, "getParent", null);
    protected static final Method GET_PATH_METHOD = NodeProxy.reflectMethod(Node.class, "getPath", null);
    protected static final Method GET_URL_METHOD = NodeProxy.reflectMethod(Node.class, "getUrl", null);
    protected static final Method HASH_CODE_METHOD = NodeProxy.reflectMethod(Object.class, "hashCode", null);
    protected static final Method IS_HIDDEN_METHOD = NodeProxy.reflectMethod(Node.class, "isHidden", null);
    protected static final Method TO_STRING_METHOD = NodeProxy.reflectMethod(Object.class, "toString", null);
    private Folder parent;
    private String path;
    private String url;
    private boolean hidden;
    private List menuDefinitionLocators;
    private boolean menuDefinitionLocatorsAggregated;
    private List menuDefinitions;
    private boolean menuDefinitionsAggregated;

    protected NodeProxy(SearchPathsSiteView view, String locatorName, Folder parent, String name, boolean hidden) {
        super(view, locatorName);
        this.parent = parent;
        if (parent != null && name != null) {
            NodeProxy parentProxy = NodeProxy.getNodeProxy(parent);
            String parentPath = parentProxy.getPath();
            String parentUrl = parentProxy.getUrl();
            String urlEncodedName = name;
            try {
                urlEncodedName = URLEncoder.encode(name, URL_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            if (parentPath.endsWith("/")) {
                this.path = parentPath + name;
                this.url = parentUrl + urlEncodedName;
            } else {
                this.path = parentPath + "/" + name;
                this.url = parentUrl + "/" + urlEncodedName;
            }
            this.hidden = hidden || parentProxy.isHidden();
        } else {
            this.path = "/";
            this.url = "/";
            this.hidden = hidden;
        }
    }

    public Node getParent() {
        return this.parent;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getUrl() {
        return this.url;
    }

    public List getMenuDefinitions() {
        if (!this.menuDefinitionsAggregated) {
            List locators = this.getMenuDefinitionLocators();
            if (locators != null) {
                this.menuDefinitions = Collections.synchronizedList(new ArrayList(locators.size()));
                Iterator locatorsIter = locators.iterator();
                while (locatorsIter.hasNext()) {
                    this.menuDefinitions.add(((SiteViewMenuDefinitionLocator)locatorsIter.next()).getMenuDefinition());
                }
            }
            this.menuDefinitionsAggregated = true;
        }
        return this.menuDefinitions;
    }

    public List getMenuDefinitionLocators() {
        if (!this.menuDefinitionLocatorsAggregated) {
            this.aggregateMenuDefinitionLocators();
            this.menuDefinitionLocatorsAggregated = true;
        }
        return this.menuDefinitionLocators;
    }

    public void mergeMenuDefinitionLocators(List definitions, Node definitionNode, String path, boolean override) {
        this.menuDefinitionLocators = SiteViewUtils.mergeMenuDefinitionLocators(definitions, definitionNode, path, override, this.menuDefinitionLocators);
    }

    public void mergeMenuDefinitionLocators(List locators) {
        this.menuDefinitionLocators = SiteViewUtils.mergeMenuDefinitionLocators(locators, this.menuDefinitionLocators);
    }

    public SiteViewMenuDefinitionLocator getMenuDefinitionLocator(String name) {
        List locators = this.getMenuDefinitionLocators();
        if (locators != null) {
            return SiteViewUtils.findMenuDefinitionLocator(locators, name);
        }
        return null;
    }

    protected void aggregateMenuDefinitionLocators() {
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof NodeProxy)) {
                object = NodeProxy.getNodeProxy(object);
            }
            if (object instanceof NodeProxy) {
                return this.path.equals(((NodeProxy)object).path);
            }
        }
        return false;
    }

    public String toString() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public static NodeProxy getNodeProxy(Object node) {
        InvocationHandler nodeProxyHandler;
        if (node != null && Proxy.isProxyClass(node.getClass()) && (nodeProxyHandler = Proxy.getInvocationHandler(node)) instanceof NodeProxy) {
            return (NodeProxy)((Object)nodeProxyHandler);
        }
        return null;
    }
}

