/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document.proxy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeSet;

public class NodeSetImpl
implements NodeSet {
    private List nodes;

    public NodeSetImpl(List nodes) {
        this.nodes = nodes;
    }

    public Node get(String name) {
        for (Node node : this.nodes) {
            if (!node.getName().equals(name) && !node.getPath().equals(name)) continue;
            return node;
        }
        return null;
    }

    public Iterator iterator() {
        return this.nodes.listIterator();
    }

    public NodeSet subset(String type) {
        ArrayList<Node> subsetNodes = null;
        for (Node node : this.nodes) {
            if (!node.getType().equals(type)) continue;
            if (subsetNodes == null) {
                subsetNodes = new ArrayList<Node>(this.nodes.size());
            }
            subsetNodes.add(node);
        }
        if (subsetNodes != null) {
            return new NodeSetImpl(subsetNodes);
        }
        return null;
    }

    public NodeSet inclusiveSubset(String regex) {
        ArrayList<Node> subsetNodes = null;
        Pattern pattern = Pattern.compile(regex);
        for (Node node : this.nodes) {
            if (!pattern.matcher(node.getName()).matches() && !pattern.matcher(node.getPath()).matches()) continue;
            if (subsetNodes == null) {
                subsetNodes = new ArrayList<Node>(this.nodes.size());
            }
            subsetNodes.add(node);
        }
        if (subsetNodes != null) {
            return new NodeSetImpl(subsetNodes);
        }
        return null;
    }

    public NodeSet exclusiveSubset(String regex) {
        ArrayList<Node> subsetNodes = null;
        Pattern pattern = Pattern.compile(regex);
        for (Node node : this.nodes) {
            if (pattern.matcher(node.getName()).matches() || pattern.matcher(node.getPath()).matches()) continue;
            if (subsetNodes == null) {
                subsetNodes = new ArrayList<Node>(this.nodes.size());
            }
            subsetNodes.add(node);
        }
        if (subsetNodes != null) {
            return new NodeSetImpl(subsetNodes);
        }
        return null;
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public void add(Node node) {
        throw new RuntimeException("NodeSet list is immutable from proxy.");
    }
}

