/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import java.util.regex.Matcher;
import org.apache.jetspeed.portalsite.impl.AbstractPatternMapping;

public class ContentTypeMapping
extends AbstractPatternMapping {
    private String mappedType;
    private boolean mappedTypeReplacements;

    public ContentTypeMapping(String pattern, String mappedType) {
        super(pattern);
        this.mappedType = mappedType;
        this.mappedTypeReplacements = mappedType.indexOf(36) != -1;
    }

    public String map(String requestPath) {
        Matcher patternMatcher = this.getPatternMatcher(requestPath);
        if (patternMatcher.find()) {
            String type = this.mappedType;
            if (this.mappedTypeReplacements) {
                for (int i = 0; i <= patternMatcher.groupCount(); ++i) {
                    String groupMatch = requestPath.substring(patternMatcher.start(i), patternMatcher.end(i));
                    type = type.replace("$" + i, groupMatch);
                }
            }
            return type;
        }
        return null;
    }
}

