/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.view;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.portalsite.view.AbstractSiteView;
import org.apache.jetspeed.portalsite.view.SiteViewMenuDefinitionLocator;
import org.apache.jetspeed.portalsite.view.SiteViewUtils;

public class PhysicalSiteView
extends AbstractSiteView {
    private static final List NULL_LOCATORS = new ArrayList(0);
    private String userPrincipal;
    private ConcurrentHashMap menuDefinitionLocatorsCache = new ConcurrentHashMap();

    public PhysicalSiteView(PageManager pageManager, String userPrincipal) {
        super(pageManager);
        this.userPrincipal = userPrincipal;
    }

    protected Folder createRootFolderView() throws FolderNotFoundException {
        try {
            return this.getPageManager().getFolder("/");
        }
        catch (NodeException ne) {
            FolderNotFoundException fnfe = new FolderNotFoundException("Root folder not found");
            fnfe.initCause((Throwable)ne);
            throw fnfe;
        }
        catch (NodeNotFoundException nnfe) {
            FolderNotFoundException fnfe = new FolderNotFoundException("Root folder not found");
            fnfe.initCause((Throwable)nnfe);
            throw fnfe;
        }
    }

    protected void checkAccessToNodeNotFound(Folder folder, String folderName) {
    }

    public List getMenuDefinitionLocators(Node node) {
        String path = node.getPath();
        List locators = (List)this.menuDefinitionLocatorsCache.get(path);
        if (locators == null) {
            if (node instanceof Folder) {
                for (Folder folder = (Folder)node; folder != null; folder = (Folder)folder.getParent()) {
                    locators = SiteViewUtils.mergeMenuDefinitionLocators(folder.getMenuDefinitions(), (Node)folder, folder.getPath(), false, locators);
                }
                locators = SiteViewUtils.mergeMenuDefinitionLocators(this.getStandardMenuDefinitionLocators(), locators);
            } else if (node instanceof Page) {
                Page page = (Page)node;
                Folder folder = (Folder)node.getParent();
                locators = SiteViewUtils.mergeMenuDefinitionLocators(page.getMenuDefinitions(), (Node)page, folder.getPath(), true, locators);
                locators = SiteViewUtils.mergeMenuDefinitionLocators(this.getMenuDefinitionLocators((Node)folder), locators);
            } else if (node instanceof DynamicPage) {
                DynamicPage dynamicPage = (DynamicPage)node;
                Folder folder = (Folder)node.getParent();
                locators = SiteViewUtils.mergeMenuDefinitionLocators(dynamicPage.getMenuDefinitions(), (Node)dynamicPage, folder.getPath(), true, locators);
                locators = SiteViewUtils.mergeMenuDefinitionLocators(this.getMenuDefinitionLocators((Node)folder), locators);
            } else if (node instanceof PageTemplate) {
                PageTemplate pageTemplate = (PageTemplate)node;
                Folder folder = (Folder)node.getParent();
                locators = SiteViewUtils.mergeMenuDefinitionLocators(pageTemplate.getMenuDefinitions(), (Node)pageTemplate, folder.getPath(), false, locators);
            }
            locators = locators != null ? locators : NULL_LOCATORS;
            List cachedLocators = this.menuDefinitionLocatorsCache.putIfAbsent(path, locators);
            locators = cachedLocators != null ? cachedLocators : locators;
        }
        return locators != NULL_LOCATORS ? locators : null;
    }

    public SiteViewMenuDefinitionLocator getMenuDefinitionLocator(Node node, String name) {
        List locators = this.getMenuDefinitionLocators(node);
        if (locators != null) {
            return SiteViewUtils.findMenuDefinitionLocator(locators, name);
        }
        return null;
    }

    public String getProfileLocatorName(Node node) {
        return null;
    }

    public Page getManagedPage(Page page) {
        return page;
    }

    public Link getManagedLink(Link link) {
        return link;
    }

    public Folder getManagedFolder(Folder folder) {
        return folder;
    }

    public PageTemplate getManagedPageTemplate(PageTemplate pageTemplate) {
        return pageTemplate;
    }

    public DynamicPage getManagedDynamicPage(DynamicPage dynamicPage) {
        return dynamicPage;
    }

    public FragmentDefinition getManagedFragmentDefinition(FragmentDefinition fragmentDefinition) {
        return fragmentDefinition;
    }

    public String getUserFolderPath() {
        return this.userPrincipal != null ? "/_user/" + this.userPrincipal : null;
    }

    public String getBaseFolderPath() {
        return "/";
    }
}

