/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.factory;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.portlet.GenericPortlet;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.PreferencesValidator;
import javax.portlet.UnavailableException;
import javax.portlet.filter.PortletFilter;
import javax.servlet.ServletContext;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.container.ContainerInfo;
import org.apache.jetspeed.container.JetspeedPortletConfigImpl;
import org.apache.jetspeed.container.JetspeedPortletContextImpl;
import org.apache.jetspeed.container.JetspeedServletContextProviderImpl;
import org.apache.jetspeed.factory.InlinePortletResourceBundle;
import org.apache.jetspeed.factory.JetspeedPortletFilterInstance;
import org.apache.jetspeed.factory.JetspeedPortletInstance;
import org.apache.jetspeed.factory.JetspeedPortletProxyInstance;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.factory.PortletFilterInstance;
import org.apache.jetspeed.factory.PortletInstance;
import org.apache.jetspeed.om.portlet.Filter;
import org.apache.jetspeed.om.portlet.Language;
import org.apache.jetspeed.om.portlet.Listener;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.util.GenericPortletUtils;
import org.apache.jetspeed.util.ReloadablePropertyResourceBundle;
import org.apache.pluto.container.RequestDispatcherService;
import org.apache.portals.bridges.common.ServletContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedPortletFactory
implements PortletFactory {
    private static final Logger log = LoggerFactory.getLogger(JetspeedPortletFactory.class);
    private Map<String, Map<String, PortletInstance>> portletCache;
    private Map<String, Map<String, PreferencesValidator>> validatorCache;
    private Map<String, Map<String, PortletFilterInstance>> portletFilterCache;
    private Map<String, List<PortletURLGenerationListener>> portletListenerCache;
    private Map<String, Map<Locale, ResourceBundle>> applicationResourceBundleCache;
    private Map<String, Map<String, Map<Locale, ResourceBundle>>> portletsResourceBundleCache;
    private final Map<String, ClassLoader> classLoaderMap;
    private PortalContext portalContext;
    private RequestDispatcherService rdService;
    private ServletContextProvider servletContextProvider;
    private boolean portletProxyUsed;
    private boolean autoSwitchEditDefaultsModeToEditMode;
    private boolean autoSwitchConfigMode;
    private String customConfigModePortletUniqueName;
    private boolean autoSwitchPreviewMode;
    private String customPreviewModePortletUniqueName;

    public JetspeedPortletFactory(RequestDispatcherService rdService) {
        this(rdService, false, false);
    }

    public JetspeedPortletFactory(RequestDispatcherService rdService, boolean autoSwitchConfigMode, boolean autoSwitchEditDefaultsModeToEditMode) {
        this(rdService, autoSwitchConfigMode, autoSwitchEditDefaultsModeToEditMode, false);
    }

    public JetspeedPortletFactory(RequestDispatcherService rdService, boolean autoSwitchConfigMode, boolean autoSwitchEditDefaultsModeToEditMode, boolean autoSwitchPreviewMode) {
        this.rdService = rdService;
        this.portletCache = Collections.synchronizedMap(new HashMap());
        this.validatorCache = Collections.synchronizedMap(new HashMap());
        this.classLoaderMap = Collections.synchronizedMap(new HashMap());
        this.portletFilterCache = Collections.synchronizedMap(new HashMap());
        this.portletListenerCache = Collections.synchronizedMap(new HashMap());
        this.applicationResourceBundleCache = Collections.synchronizedMap(new HashMap());
        this.portletsResourceBundleCache = Collections.synchronizedMap(new HashMap());
        this.autoSwitchConfigMode = autoSwitchConfigMode;
        this.autoSwitchEditDefaultsModeToEditMode = autoSwitchEditDefaultsModeToEditMode;
        this.autoSwitchPreviewMode = autoSwitchPreviewMode;
        this.portletProxyUsed = this.autoSwitchConfigMode || this.autoSwitchEditDefaultsModeToEditMode || this.autoSwitchPreviewMode;
        this.servletContextProvider = new JetspeedServletContextProviderImpl(rdService);
    }

    protected ResourceBundle loadResourceBundle(Locale locale, String bundleName, ClassLoader cl) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(bundleName, locale, cl);
            if (resourceBundle instanceof PropertyResourceBundle) {
                resourceBundle = new ReloadablePropertyResourceBundle((PropertyResourceBundle)resourceBundle, bundleName);
            }
        }
        catch (MissingResourceException x) {
            return null;
        }
        return resourceBundle;
    }

    public void setPortalContext(PortalContext portalContext) {
        this.portalContext = portalContext;
    }

    public void setPortletProxyUsed(boolean portletProxyUsed) {
        this.portletProxyUsed = portletProxyUsed;
    }

    public boolean getPortletProxyUsed() {
        return this.portletProxyUsed;
    }

    public void setCustomConfigModePortletUniqueName(String customConfigModePortletUniqueName) {
        this.customConfigModePortletUniqueName = customConfigModePortletUniqueName;
    }

    public String getCustomConfigModePortletUniqueName() {
        return this.customConfigModePortletUniqueName;
    }

    public void setCustomPreviewModePortletUniqueName(String customPreviewModePortletUniqueName) {
        this.customPreviewModePortletUniqueName = customPreviewModePortletUniqueName;
    }

    public String getCustomPreviewModePortletUniqueName() {
        return this.customPreviewModePortletUniqueName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPortletApplication(PortletApplication pa, ClassLoader cl) {
        Map<String, ClassLoader> map = this.classLoaderMap;
        synchronized (map) {
            this.unregisterPortletApplication(pa);
            this.classLoaderMap.put(pa.getName(), cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortletApplication(PortletApplication pa) {
        String paName = pa.getName();
        ClassLoader paCl = this.classLoaderMap.remove(paName);
        if (paCl != null) {
            block17: {
                this.applicationResourceBundleCache.remove(paName);
                this.portletsResourceBundleCache.remove(paName);
                Map<String, PortletInstance> portletInstanceCache = this.portletCache.remove(paName);
                Map<String, PortletFilterInstance> portletFilterInstanceCache = this.portletFilterCache.remove(paName);
                ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    String msg;
                    Map<String, PortletInstance> map;
                    Thread.currentThread().setContextClassLoader(paCl);
                    if (portletInstanceCache != null && !portletInstanceCache.isEmpty()) {
                        map = portletInstanceCache;
                        synchronized (map) {
                            for (PortletInstance portlet : portletInstanceCache.values()) {
                                try {
                                    portlet.destroy();
                                }
                                catch (Exception e) {
                                    msg = "Exception occurred during destroying portlet " + portlet.getClass();
                                    log.error(msg, (Throwable)e);
                                }
                            }
                        }
                    }
                    if (portletFilterInstanceCache == null || portletFilterInstanceCache.isEmpty()) break block17;
                    map = portletFilterInstanceCache;
                    synchronized (map) {
                        for (PortletFilterInstance portletFilter : portletFilterInstanceCache.values()) {
                            try {
                                portletFilter.destroy();
                            }
                            catch (Exception e) {
                                msg = "Exception occurred during destroying portlet " + portletFilter.getClass();
                                log.error(msg, (Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                }
            }
            this.validatorCache.remove(paName);
            this.portletListenerCache.remove(paName);
        }
    }

    public PreferencesValidator getPreferencesValidator(PortletDefinition pd) {
        PreferencesValidator validator = null;
        try {
            String className;
            String paName = pd.getApplication().getName();
            String pdName = pd.getPortletName();
            Map<String, Object> instanceCache = this.validatorCache.get(paName);
            PreferencesValidator preferencesValidator = validator = instanceCache != null ? instanceCache.get(pdName) : null;
            if (validator == null && (className = pd.getPreferenceValidatorClassname()) != null) {
                ClassLoader paCl = this.classLoaderMap.get(paName);
                if (paCl == null) {
                    throw new UnavailableException("Portlet Application " + paName + " not available");
                }
                try {
                    Class<?> clazz = paCl.loadClass(className);
                    validator = (PreferencesValidator)clazz.newInstance();
                    if (instanceCache == null) {
                        instanceCache = Collections.synchronizedMap(new HashMap());
                        this.validatorCache.put(paName, instanceCache);
                    }
                    instanceCache.put(pdName, validator);
                }
                catch (Exception e) {
                    String msg = "Cannot create PreferencesValidator instance " + className + " for Portlet " + pdName;
                    log.error(msg, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return validator;
    }

    public ResourceBundle getResourceBundle(PortletApplication pa, Locale locale) {
        ResourceBundle bundle = null;
        try {
            if (locale != null && pa.getResourceBundle() != null) {
                String paName = pa.getName();
                Map<Locale, ResourceBundle> bundleCache = this.applicationResourceBundleCache.get(paName);
                if (bundleCache == null) {
                    bundleCache = Collections.synchronizedMap(new HashMap());
                    this.applicationResourceBundleCache.put(paName, bundleCache);
                }
                bundle = bundleCache.get(locale);
                if (!bundleCache.containsKey(locale)) {
                    ClassLoader paCl = this.classLoaderMap.get(paName);
                    if (paCl == null) {
                        throw new UnavailableException("Portlet Application " + paName + " not available");
                    }
                    bundle = this.loadResourceBundle(locale, pa.getResourceBundle(), paCl);
                    bundleCache.put(locale, bundle);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return bundle;
    }

    public ResourceBundle getResourceBundle(PortletDefinition pd, Locale locale) {
        ResourceBundle bundle = null;
        try {
            Map<Locale, ResourceBundle> bundleCache;
            String paName = pd.getApplication().getName();
            String pdName = pd.getPortletName();
            Map<String, Map<Locale, ResourceBundle>> portletResourceBundleCache = this.portletsResourceBundleCache.get(paName);
            if (portletResourceBundleCache == null) {
                this.portletsResourceBundleCache.put(paName, Collections.synchronizedMap(new HashMap()));
                portletResourceBundleCache = this.portletsResourceBundleCache.get(paName);
            }
            if ((bundleCache = portletResourceBundleCache.get(pdName)) == null) {
                portletResourceBundleCache.put(pdName, Collections.synchronizedMap(new HashMap()));
                bundleCache = portletResourceBundleCache.get(pdName);
            }
            if ((bundle = bundleCache.get(locale)) == null) {
                Language l = pd.getLanguage(locale);
                if (pd.getResourceBundle() == null) {
                    bundle = new InlinePortletResourceBundle(l.getTitle(), l.getShortTitle(), l.getKeywords());
                } else {
                    ClassLoader paCl = this.classLoaderMap.get(paName);
                    if (paCl == null) {
                        throw new UnavailableException("Portlet Application " + paName + " not available");
                    }
                    ResourceBundle loadedBundle = this.loadResourceBundle(l.getLocale(), pd.getResourceBundle(), paCl);
                    bundle = loadedBundle != null ? new InlinePortletResourceBundle(l.getTitle(), l.getShortTitle(), l.getKeywords(), loadedBundle) : new InlinePortletResourceBundle(l.getTitle(), l.getShortTitle(), l.getKeywords());
                }
                bundleCache.put(locale, bundle);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return bundle;
    }

    public PortletInstance getPortletInstance(ServletContext servletContext, PortletDefinition pd) throws PortletException {
        return this.getPortletInstance(servletContext, pd, this.portletProxyUsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletInstance getPortletInstance(ServletContext servletContext, PortletDefinition pd, boolean proxyUsed) throws PortletException {
        PortletInstance portlet;
        block17: {
            portlet = null;
            PortletApplication pa = pd.getApplication();
            String paName = pa.getName();
            String pdName = pd.getPortletName();
            try {
                Map<String, Object> instanceCache = this.portletCache.get(paName);
                if (instanceCache != null) {
                    portlet = instanceCache.get(pdName);
                }
                if (portlet != null && this.portletProxyUsed && !proxyUsed && portlet.isProxyInstance()) {
                    portlet = null;
                }
                if (portlet != null) break block17;
                ClassLoader paCl = this.classLoaderMap.get(paName);
                if (paCl == null) {
                    throw new UnavailableException("Portlet Application " + paName + " not available");
                }
                ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = paCl.loadClass(pd.getPortletClass());
                    try {
                        Thread.currentThread().setContextClassLoader(paCl);
                        portlet = proxyUsed ? new JetspeedPortletProxyInstance(pd.getPortletName(), (Portlet)clazz.newInstance(), this.autoSwitchEditDefaultsModeToEditMode, this.autoSwitchConfigMode, this.customConfigModePortletUniqueName, this.autoSwitchPreviewMode, this.customPreviewModePortletUniqueName) : new JetspeedPortletInstance(pdName, (Portlet)clazz.newInstance());
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                    }
                }
                catch (Exception e) {
                    String msg = "Cannot create Portlet instance " + pd.getPortletClass() + " for Portlet Application " + paName;
                    log.error(msg, (Throwable)e);
                    throw new UnavailableException(msg);
                }
                JetspeedPortletContextImpl portletContext = new JetspeedPortletContextImpl(servletContext, pa, ContainerInfo.getInfo(), this.portalContext.getConfiguration(), this.rdService, this.servletContextProvider);
                JetspeedPortletConfigImpl portletConfig = new JetspeedPortletConfigImpl(this, portletContext, pd);
                try {
                    try {
                        Thread.currentThread().setContextClassLoader(paCl);
                        portlet.init((PortletConfig)portletConfig);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                    }
                }
                catch (PortletException e1) {
                    log.error("Failed to initialize Portlet " + pd.getPortletClass() + " for Portlet Application " + paName, (Throwable)e1);
                    throw e1;
                }
                if (instanceCache == null) {
                    instanceCache = Collections.synchronizedMap(new HashMap());
                    this.portletCache.put(paName, instanceCache);
                }
                instanceCache.put(pdName, portlet);
            }
            catch (PortletException pe) {
                throw pe;
            }
            catch (Throwable e) {
                log.error("PortletFactory: Failed to load portlet " + pd.getPortletClass(), e);
                throw new UnavailableException("Failed to load portlet " + pd.getPortletClass() + ": " + e.toString());
            }
        }
        return portlet;
    }

    public void updatePortletConfig(PortletDefinition pd) {
        if (pd != null) {
            PortletInstance instance;
            Map<String, PortletInstance> instanceCache = this.portletCache.get(pd.getApplication().getName());
            PortletInstance portletInstance = instance = instanceCache != null ? instanceCache.get(pd.getPortletName()) : null;
            if (instance != null) {
                JetspeedPortletConfigImpl config = (JetspeedPortletConfigImpl)instance.getConfig();
                config.setPortletDefinition(pd);
            }
        }
    }

    public ClassLoader getPortletApplicationClassLoader(PortletApplication pa) {
        return pa != null ? this.classLoaderMap.get(pa.getName()) : null;
    }

    public boolean isPortletApplicationRegistered(PortletApplication pa) {
        return this.getPortletApplicationClassLoader(pa) != null;
    }

    public List<PortletURLGenerationListener> getPortletApplicationListeners(PortletApplication pa) throws PortletException {
        List paListenerList;
        String paName = pa.getName();
        List<PortletURLGenerationListener> cacheListeners = this.portletListenerCache.get(paName);
        if (cacheListeners == null && (paListenerList = pa.getListeners()) != null) {
            cacheListeners = new ArrayList<PortletURLGenerationListener>();
            ClassLoader paCl = this.getPortletApplicationClassLoader(pa);
            if (paCl == null) {
                throw new UnavailableException("Portlet Application " + paName + " not available");
            }
            for (Listener listener : paListenerList) {
                String message;
                try {
                    Class<?> clazz = paCl.loadClass(listener.getListenerClass());
                    PortletURLGenerationListener listenerInstance = (PortletURLGenerationListener)clazz.newInstance();
                    cacheListeners.add(listenerInstance);
                }
                catch (ClassNotFoundException e) {
                    message = "The listener class isn't found: " + listener.getListenerClass();
                    log.error(message);
                }
                catch (InstantiationException e) {
                    message = "The listener class instantiation fail: " + listener.getListenerClass();
                    log.error(message);
                }
                catch (IllegalAccessException e) {
                    message = "IllegalAccessException on the listener class: " + listener.getListenerClass();
                    log.error(message);
                }
            }
            this.portletListenerCache.put(paName, cacheListeners);
        }
        if (cacheListeners != null) {
            return Collections.unmodifiableList(cacheListeners);
        }
        return Collections.emptyList();
    }

    public PortletFilterInstance getPortletFilterInstance(PortletApplication pa, String filterName) throws PortletException {
        Filter filter;
        String paName = pa.getName();
        PortletFilterInstance filterInstance = null;
        Map<String, Object> cacheFilters = this.portletFilterCache.get(paName);
        if (cacheFilters != null) {
            filterInstance = cacheFilters.get(filterName);
        }
        if (filterInstance == null && (filter = pa.getFilter(filterName)) != null) {
            ClassLoader paCl = this.classLoaderMap.get(paName);
            if (paCl == null) {
                throw new UnavailableException("Portlet Application " + paName + " not available");
            }
            try {
                Class<?> clazz = paCl.loadClass(filter.getFilterClass());
                PortletFilter portletFilter = (PortletFilter)clazz.newInstance();
                filterInstance = new JetspeedPortletFilterInstance(filter, portletFilter);
            }
            catch (ClassNotFoundException e) {
                String message = "The filter class isn't found: " + filter.getFilterClass();
                log.error(message);
                throw new UnavailableException(message);
            }
            catch (InstantiationException e) {
                String message = "The filter class instantiation fail: " + filter.getFilterClass();
                log.error(message);
                throw new UnavailableException(message);
            }
            catch (IllegalAccessException e) {
                String message = "IllegalAccessException on the filter class: " + filter.getFilterClass();
                log.error(message);
                throw new UnavailableException(message);
            }
            if (cacheFilters == null) {
                cacheFilters = Collections.synchronizedMap(new HashMap());
                this.portletFilterCache.put(paName, cacheFilters);
            }
            cacheFilters.put(filterName, filterInstance);
        }
        return filterInstance;
    }

    public boolean hasRenderHelperMethod(PortletDefinition pd, PortletMode mode) {
        PortletInstance portletInstance = null;
        String paName = pd.getApplication().getName();
        String pdName = pd.getPortletName();
        Map<String, PortletInstance> instanceCache = this.portletCache.get(paName);
        if (instanceCache != null) {
            portletInstance = instanceCache.get(pdName);
        }
        if (portletInstance != null) {
            return portletInstance.hasRenderHelperMethod(mode);
        }
        ClassLoader paCl = this.classLoaderMap.get(paName);
        if (paCl != null) {
            try {
                Method helperMethod;
                Class<?> portletClazz = paCl.loadClass(pd.getPortletClass());
                if (GenericPortlet.class.isAssignableFrom(portletClazz) && (helperMethod = GenericPortletUtils.getRenderModeHelperMethod(portletClazz, (PortletMode)mode)) != null) {
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadResourceBundles(PortletApplication pa) throws PortletException {
        String paName = pa.getName();
        Map<Locale, ResourceBundle> bundleCache = this.applicationResourceBundleCache.get(paName);
        if (bundleCache != null) {
            ArrayList<Locale> locales = null;
            Map<Locale, ResourceBundle> map = bundleCache;
            synchronized (map) {
                locales = new ArrayList<Locale>(bundleCache.keySet());
            }
            for (Locale locale : locales) {
                ResourceBundle bundle = bundleCache.get(locale);
                if (bundle == null) continue;
                if (bundle instanceof InlinePortletResourceBundle) {
                    bundle = ((InlinePortletResourceBundle)bundle).getParent();
                }
                if (!(bundle instanceof ReloadablePropertyResourceBundle)) continue;
                try {
                    ((ReloadablePropertyResourceBundle)bundle).reload(this.getPortletApplicationClassLoader(pa));
                }
                catch (IOException e) {
                    log.error("Failed to reload resource bundle of " + paName + " for locale, " + locale, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadResourceBundles(PortletDefinition pd) throws PortletException {
        Map<Locale, ResourceBundle> bundleCache;
        PortletApplication pa = pd.getApplication();
        String paName = pa.getName();
        String pdName = pd.getPortletName();
        Map<String, Map<Locale, ResourceBundle>> portletResourceBundleCache = this.portletsResourceBundleCache.get(paName);
        if (portletResourceBundleCache != null && (bundleCache = portletResourceBundleCache.get(pdName)) != null) {
            ArrayList<Locale> locales = null;
            Map<Locale, ResourceBundle> map = bundleCache;
            synchronized (map) {
                locales = new ArrayList<Locale>(bundleCache.keySet());
            }
            for (Locale locale : locales) {
                ResourceBundle bundle = bundleCache.get(locale);
                if (bundle == null) continue;
                if (bundle instanceof InlinePortletResourceBundle) {
                    bundle = ((InlinePortletResourceBundle)bundle).getParent();
                }
                if (!(bundle instanceof ReloadablePropertyResourceBundle)) continue;
                try {
                    ((ReloadablePropertyResourceBundle)bundle).reload(this.getPortletApplicationClassLoader(pa));
                }
                catch (IOException e) {
                    log.error("Failed to reload resource bundle of " + paName + "::" + pdName + " for locale, " + locale, (Throwable)e);
                }
            }
        }
    }
}

