/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.factory;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.UnavailableException;
import org.apache.jetspeed.container.JetspeedPortletConfig;
import org.apache.jetspeed.factory.PortletInstance;
import org.apache.jetspeed.util.GenericPortletUtils;

public class JetspeedPortletInstance
implements PortletInstance {
    private Portlet portlet;
    private JetspeedPortletConfig config;
    private boolean destroyed;
    private final String portletName;
    protected Map<PortletMode, Boolean> helperMethodAccessibilities;

    public JetspeedPortletInstance(String portletName, Portlet portlet) {
        this.portletName = portletName;
        this.portlet = portlet;
    }

    private void checkAvailable() throws UnavailableException {
        if (this.destroyed) {
            throw new UnavailableException("Portlet " + this.portletName + " no longer available");
        }
    }

    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.config != null) {
                this.portlet.destroy();
            }
        }
    }

    public boolean equals(Object obj) {
        return this.portlet.equals(obj);
    }

    public int hashCode() {
        return this.portlet.hashCode();
    }

    public void init(PortletConfig config) throws PortletException {
        this.portlet.init(config);
        this.config = (JetspeedPortletConfig)config;
    }

    public JetspeedPortletConfig getConfig() {
        return this.config;
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.checkAvailable();
        this.portlet.processAction(request, response);
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.checkAvailable();
        this.portlet.render(request, response);
    }

    public String toString() {
        return this.portlet.toString();
    }

    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        if (this.portlet instanceof EventPortlet) {
            this.checkAvailable();
            ((EventPortlet)this.portlet).processEvent(request, response);
        }
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        if (this.portlet instanceof ResourceServingPortlet) {
            this.checkAvailable();
            ((ResourceServingPortlet)this.portlet).serveResource(request, response);
        }
    }

    public Portlet getRealPortlet() {
        return this.portlet;
    }

    public boolean isProxyInstance() {
        return false;
    }

    public boolean hasRenderHelperMethod(PortletMode mode) {
        Boolean accessible;
        if (this.helperMethodAccessibilities == null) {
            this.helperMethodAccessibilities = Collections.synchronizedMap(new HashMap());
        }
        if ((accessible = this.helperMethodAccessibilities.get(mode)) != null) {
            return accessible;
        }
        Method helperMethod = null;
        Portlet nonProxyPortletObject = this.getNonProxyPortletObject();
        if (nonProxyPortletObject instanceof GenericPortlet) {
            helperMethod = GenericPortletUtils.getRenderModeHelperMethod((GenericPortlet)((GenericPortlet)nonProxyPortletObject), (PortletMode)mode);
        }
        boolean helperMethodAccessible = helperMethod != null;
        this.helperMethodAccessibilities.put(mode, helperMethodAccessible ? Boolean.TRUE : Boolean.FALSE);
        return helperMethodAccessible;
    }

    protected Portlet getNonProxyPortletObject() {
        return this.portlet;
    }
}

