/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.container.JetspeedPortletContext;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.RequestDispatcherService;
import org.apache.portals.bridges.common.ServletContextProvider;

public class JetspeedServletContextProviderImpl
implements ServletContextProvider {
    private static final String SERVLET_CONTEXT = ServletContextProvider.class.getName() + ".context";
    private static final String SERVLET_REQUEST = ServletContextProvider.class.getName() + ".request";
    private static final String SERVLET_RESPONSE = ServletContextProvider.class.getName() + ".response";
    private RequestDispatcherService requestDispatcherService;

    public JetspeedServletContextProviderImpl(RequestDispatcherService requestDispatcherService) {
        this.requestDispatcherService = requestDispatcherService;
    }

    public ServletContext getServletContext(GenericPortlet portlet) {
        PortletWindow window = Jetspeed.getCurrentRequestContext().getCurrentPortletWindow();
        ServletContext servletContext = (ServletContext)window.getAttribute(SERVLET_CONTEXT);
        if (servletContext == null) {
            servletContext = ServletContextProxy.createProxy(((JetspeedPortletContext)portlet.getPortletContext()).getServletContext(), portlet.getPortletContext());
            window.setAttribute(SERVLET_CONTEXT, (Object)servletContext);
        }
        return servletContext;
    }

    public HttpServletRequest getHttpServletRequest(GenericPortlet portlet, PortletRequest request) {
        PortletWindow window = Jetspeed.getCurrentRequestContext().getCurrentPortletWindow();
        HttpServletRequest req = (HttpServletRequest)window.getAttribute(SERVLET_REQUEST);
        if (req == null) {
            PortletRequestContext rc = window.getPortletRequestContext();
            req = this.requestDispatcherService.getRequestWrapper(rc.getServletContext(), rc.getServletRequest(), request, null, true, false);
            req.setAttribute("javax.portlet.config", (Object)rc.getPortletConfig());
            req.setAttribute("javax.portlet.request", (Object)window.getPortletRequest());
            req.setAttribute("javax.portlet.response", (Object)window.getPortletResponse());
            window.setAttribute(SERVLET_REQUEST, (Object)req);
        }
        return req;
    }

    public HttpServletResponse getHttpServletResponse(GenericPortlet portlet, PortletResponse response) {
        PortletWindow window = Jetspeed.getCurrentRequestContext().getCurrentPortletWindow();
        Object res = (HttpServletResponse)window.getAttribute(SERVLET_RESPONSE);
        if (res == null) {
            boolean included = window.getAttribute("org.apache.jetspeed.portlet.container.invoker.useForward") == null;
            PortletRequestContext rc = window.getPortletRequestContext();
            res = this.requestDispatcherService.getResponseWraper(rc.getServletContext(), rc.getServletResponse(), window.getPortletRequest(), response, included);
            if (PortletWindow.Action.RENDER == window.getAction() && !included) {
                res = new HttpServletPortletResourceResponseWrapper((HttpServletResponse)res);
            }
            window.setAttribute(SERVLET_RESPONSE, res);
        }
        return res;
    }

    private static class HttpServletPortletResourceResponseWrapper
    extends HttpServletResponseWrapper {
        private HttpServletResponse response;

        public HttpServletPortletResourceResponseWrapper(HttpServletResponse response) {
            super(response);
            this.response = response;
        }

        public void sendRedirect(String location) throws IOException {
            this.response.sendRedirect(location);
        }
    }

    private static class ServletContextProxy
    implements InvocationHandler {
        private ServletContext servletContext;
        private PortletContext portletContext;

        public static ServletContext createProxy(ServletContext servletContext, PortletContext portletContext) {
            HashSet interfaces = new HashSet();
            interfaces.add(ServletContext.class);
            Class<?> current = servletContext.getClass();
            while (current != null) {
                try {
                    Class<?>[] currentInterfaces = current.getInterfaces();
                    for (int i = 0; i < currentInterfaces.length; ++i) {
                        interfaces.add(currentInterfaces[i]);
                    }
                    current = current.getSuperclass();
                }
                catch (Exception e) {
                    current = null;
                }
            }
            return (ServletContext)Proxy.newProxyInstance(servletContext.getClass().getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new ServletContextProxy(servletContext, portletContext));
        }

        private ServletContextProxy(ServletContext servletContext, PortletContext portletContext) {
            this.servletContext = servletContext;
            this.portletContext = portletContext;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object retval = null;
            if (("getRequestDispatcher".equals(method.getName()) || "getNamedDispatcher".equals(method.getName())) && args != null && args.length == 1 && args[0] instanceof String) {
                retval = "getRequestDispatcher".equals(method.getName()) ? this.portletContext.getRequestDispatcher((String)args[0]) : this.portletContext.getNamedDispatcher((String)args[0]);
            } else {
                try {
                    retval = method.invoke((Object)this.servletContext, args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            return retval;
        }
    }
}

