/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.rules.impl;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.rules.FallbackCriterionResolver;
import org.apache.jetspeed.profiler.rules.ProfileResolvers;
import org.apache.jetspeed.profiler.rules.ProfilingRule;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.profiler.rules.RuleCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.AbstractProfilingRule;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleFallbackProfilingRule
extends AbstractProfilingRule
implements ProfilingRule {
    protected static final Logger log = LoggerFactory.getLogger(RoleFallbackProfilingRule.class);
    private static final long serialVersionUID = 1L;

    public RoleFallbackProfilingRule() {
        this.setClassname(this.getClass().getName());
    }

    public RoleFallbackProfilingRule(ProfileResolvers resolvers) {
        super(resolvers);
        this.setClassname(this.getClass().getName());
    }

    public ProfileLocator apply(RequestContext context, Profiler service) {
        StringBuffer key = new StringBuffer();
        int count = 0;
        Iterator<RuleCriterion> criteria = this.getRuleCriteria().iterator();
        while (criteria.hasNext()) {
            String value;
            RuleCriterionResolver resolver;
            RuleCriterion criterion = criteria.next();
            if (criterion.getType() == null) {
                log.warn("Invalid criterion provided - type null on rule " + this);
            }
            if ((resolver = this.getResolver(criterion.getType())) == null) {
                resolver = this.getDefaultResolver();
            }
            if ((value = resolver.resolve(context, criterion)) != null && resolver instanceof FallbackCriterionResolver) {
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    key.append(criterion.getName());
                    key.append(":");
                    key.append(token);
                    if (!tokenizer.hasMoreTokens()) continue;
                    key.append(":");
                }
            } else {
                key.append(criterion.getName());
                key.append(":");
                key.append(value);
            }
            if (criteria.hasNext()) {
                key.append(":");
            }
            ++count;
        }
        String requestPath = context.getPath();
        String locatorKey = (requestPath != null ? requestPath : "/") + ":" + key.toString();
        ProfileLocator locator = this.getLocatorFromCache(locatorKey);
        if (locator != null) {
            return locator;
        }
        locator = service.createLocator(context);
        for (RuleCriterion criterion : this.getRuleCriteria()) {
            RuleCriterionResolver resolver;
            if (criterion.getType() == null) {
                log.warn("Invalid criterion provided - name or type null on rule " + this);
            }
            if ((resolver = this.getResolver(criterion.getType())) == null) continue;
            String value = resolver.resolve(context, criterion);
            boolean isControl = resolver.isControl(criterion);
            boolean isNavigation = resolver.isNavigation(criterion);
            if (value != null && resolver instanceof FallbackCriterionResolver) {
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    locator.add(criterion, isControl, isNavigation, token);
                }
                continue;
            }
            locator.add(criterion, isControl, isNavigation, value);
        }
        this.addLocatorToCache(locatorKey, locator);
        return locator;
    }
}

