/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.search.lucene;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.jetspeed.search.BaseParsedObject;
import org.apache.jetspeed.search.HandlerFactory;
import org.apache.jetspeed.search.ObjectHandler;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.search.SearchResults;
import org.apache.jetspeed.search.lucene.SearchResultsImpl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchEngineImpl
implements SearchEngine {
    protected static final Logger log = LoggerFactory.getLogger(SearchEngineImpl.class);
    private File rootIndexDir = null;
    private String analyzerClassName = null;
    private boolean optimizeAfterUpdate = true;
    private HandlerFactory handlerFactory;
    private static final int KEYWORD = 0;
    private static final int TEXT = 1;

    public SearchEngineImpl(String indexRoot, String analyzerClassName, boolean optimzeAfterUpdate, HandlerFactory handlerFactory) throws Exception {
        this.rootIndexDir = new File(indexRoot);
        this.analyzerClassName = analyzerClassName;
        this.optimizeAfterUpdate = optimzeAfterUpdate;
        this.handlerFactory = handlerFactory;
        try {
            IndexSearcher searcher = null;
            searcher = new IndexSearcher(this.rootIndexDir.getPath());
            searcher.close();
        }
        catch (Exception e) {
            if (this.rootIndexDir.exists()) {
                log.warn("Failed to open Portal Registry indexes in {}. {}", (Object)this.rootIndexDir.getPath(), (Object)e);
            }
            try {
                this.rootIndexDir.delete();
                this.rootIndexDir.mkdirs();
                IndexWriter indexWriter = new IndexWriter(this.rootIndexDir, this.newAnalyzer(), true);
                indexWriter.close();
                indexWriter = null;
                log.warn("Re-created Lucene Index in " + this.rootIndexDir.getPath());
            }
            catch (Exception e1) {
                String message = "Cannot RECREATE Portlet Registry indexes in " + this.rootIndexDir.getPath();
                log.error(message, (Throwable)e1);
                throw new Exception(message);
            }
        }
    }

    public boolean add(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.add(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean add(Collection objects) {
        IndexWriter indexWriter;
        boolean result = false;
        try {
            indexWriter = new IndexWriter(this.rootIndexDir, this.newAnalyzer(), false);
        }
        catch (IOException e) {
            return result;
        }
        for (Object o : objects) {
            String[] keywordArray;
            ObjectHandler handler = null;
            try {
                handler = this.handlerFactory.getHandler(o);
            }
            catch (Exception e) {
                continue;
            }
            ParsedObject parsedObject = handler.parseObject(o);
            Document doc = new Document();
            if (parsedObject.getKey() != null) {
                doc.add((Fieldable)new Field("fieldname.key", parsedObject.getKey(), Field.Store.YES, Field.Index.UN_TOKENIZED));
            }
            if (parsedObject.getType() != null) {
                doc.add((Fieldable)new Field("fieldname.type", parsedObject.getType(), Field.Store.YES, Field.Index.TOKENIZED));
            }
            if (parsedObject.getTitle() != null) {
                doc.add((Fieldable)new Field("fieldname.title", parsedObject.getTitle(), Field.Store.YES, Field.Index.TOKENIZED));
            }
            if (parsedObject.getDescription() != null) {
                doc.add((Fieldable)new Field("fieldname.description", parsedObject.getDescription(), Field.Store.YES, Field.Index.TOKENIZED));
            }
            if (parsedObject.getContent() != null) {
                doc.add((Fieldable)new Field("fieldname.content", parsedObject.getContent(), Field.Store.YES, Field.Index.TOKENIZED));
            }
            if (parsedObject.getLanguage() != null) {
                doc.add((Fieldable)new Field("fieldname.language", parsedObject.getLanguage(), Field.Store.YES, Field.Index.TOKENIZED));
            }
            if (parsedObject.getURL() != null) {
                doc.add((Fieldable)new Field("fieldname.url", parsedObject.getURL().toString(), Field.Store.YES, Field.Index.TOKENIZED));
            }
            if (parsedObject.getClassName() != null) {
                doc.add((Fieldable)new Field("fieldname.className", parsedObject.getClassName(), Field.Store.YES, Field.Index.TOKENIZED));
            }
            if ((keywordArray = parsedObject.getKeywords()) != null) {
                for (int i = 0; i < keywordArray.length; ++i) {
                    String keyword = keywordArray[i];
                    doc.add((Fieldable)new Field("fieldname.keywords", keyword, Field.Store.YES, Field.Index.UN_TOKENIZED));
                }
            }
            Map keywords = parsedObject.getKeywordsMap();
            this.addFieldsToDocument(doc, keywords, 0);
            Map fields = parsedObject.getFields();
            this.addFieldsToDocument(doc, fields, 1);
            try {
                indexWriter.addDocument(doc);
            }
            catch (IOException e) {
                // empty catch block
            }
            result = true;
        }
        try {
            if (this.optimizeAfterUpdate) {
                indexWriter.optimize();
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                indexWriter.close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    public boolean remove(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.remove(c);
    }

    public synchronized boolean remove(Collection objects) {
        boolean result = false;
        try {
            IndexReader indexReader = IndexReader.open((File)this.rootIndexDir);
            for (Object o : objects) {
                ObjectHandler handler = this.handlerFactory.getHandler(o);
                ParsedObject parsedObject = handler.parseObject(o);
                Term term = null;
                if (parsedObject.getKey() == null) continue;
                term = new Term("fieldname.key", parsedObject.getKey());
                int rc = indexReader.deleteDocuments(term);
                result = rc > 0;
            }
            indexReader.close();
            if (this.optimizeAfterUpdate) {
                this.optimize();
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean update(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.update(c);
    }

    public synchronized boolean update(Collection objects) {
        boolean result = false;
        try {
            this.remove(objects);
            result = true;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (result) {
                this.add(objects);
                result = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public synchronized boolean optimize() {
        boolean result = false;
        try {
            IndexWriter indexWriter = new IndexWriter(this.rootIndexDir, this.newAnalyzer(), false);
            indexWriter.optimize();
            indexWriter.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public SearchResults search(String queryString) {
        IndexSearcher searcher = null;
        Hits hits = null;
        try {
            searcher = new IndexSearcher(this.rootIndexDir.getPath());
        }
        catch (IOException e) {
            return null;
        }
        Analyzer analyzer = this.newAnalyzer();
        String[] searchFields = new String[]{"fieldname.content", "fieldname.description", "fieldname.fields", "fieldname.key", "fieldname.keywords", "fieldname.language", "fieldname.score", "fieldname.title", "fieldname.type", "fieldname.url", "fieldname.className"};
        Query query = null;
        try {
            String[] s = new String[searchFields.length];
            for (int i = 0; i < s.length; ++i) {
                s[i] = queryString;
            }
            query = MultiFieldQueryParser.parse((String[])s, (String[])searchFields, (Analyzer)analyzer);
        }
        catch (ParseException e) {
            ArrayList resultList = new ArrayList();
            SearchResultsImpl results = new SearchResultsImpl(resultList);
            return results;
        }
        try {
            hits = searcher.search(query);
        }
        catch (IOException e) {
            ArrayList resultList = new ArrayList();
            SearchResultsImpl results = new SearchResultsImpl(resultList);
            return results;
        }
        int hitNum = hits.length();
        ArrayList<BaseParsedObject> resultList = new ArrayList<BaseParsedObject>(hitNum);
        for (int i = 0; i < hitNum; ++i) {
            BaseParsedObject result = new BaseParsedObject();
            try {
                Field[] keywords;
                Field url;
                Field classname;
                Field language;
                Field content;
                Field title;
                Field description;
                Field key;
                Document doc = hits.doc(i);
                this.addFieldsToParsedObject(doc, result);
                result.setScore(hits.score(i));
                Field type = doc.getField("fieldname.type");
                if (type != null) {
                    result.setType(type.stringValue());
                }
                if ((key = doc.getField("fieldname.key")) != null) {
                    result.setKey(key.stringValue());
                }
                if ((description = doc.getField("fieldname.description")) != null) {
                    result.setDescription(description.stringValue());
                }
                if ((title = doc.getField("fieldname.title")) != null) {
                    result.setTitle(title.stringValue());
                }
                if ((content = doc.getField("fieldname.content")) != null) {
                    result.setContent(content.stringValue());
                }
                if ((language = doc.getField("fieldname.language")) != null) {
                    result.setLanguage(language.stringValue());
                }
                if ((classname = doc.getField("fieldname.className")) != null) {
                    result.setClassName(classname.stringValue());
                }
                if ((url = doc.getField("fieldname.url")) != null) {
                    result.setURL(new URL(url.stringValue()));
                }
                if ((keywords = doc.getFields("fieldname.keywords")) != null) {
                    String[] keywordArray = new String[keywords.length];
                    for (int j = 0; j < keywords.length; ++j) {
                        Field keyword = keywords[j];
                        keywordArray[j] = keyword.stringValue();
                    }
                    result.setKeywords(keywordArray);
                }
                resultList.add(i, result);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (searcher != null) {
            try {
                searcher.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        SearchResultsImpl results = new SearchResultsImpl(resultList);
        return results;
    }

    private Analyzer newAnalyzer() {
        StandardAnalyzer rval = null;
        if (this.analyzerClassName != null) {
            try {
                Class<?> analyzerClass = Class.forName(this.analyzerClassName);
                rval = (Analyzer)analyzerClass.newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (rval == null) {
            rval = new StandardAnalyzer();
        }
        return rval;
    }

    private void addFieldsToDocument(Document doc, Map fields, int type) {
        if (fields != null) {
            for (Object key : fields.keySet()) {
                Object values;
                if (key == null || (values = fields.get(key)) == null) continue;
                if (values instanceof Collection) {
                    for (Object value : (Collection)values) {
                        if (value == null) continue;
                        if (type == 1) {
                            doc.add((Fieldable)new Field(key.toString(), value.toString(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                            continue;
                        }
                        doc.add((Fieldable)new Field(key.toString(), value.toString(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                    }
                    continue;
                }
                if (type == 1) {
                    doc.add((Fieldable)new Field(key.toString(), values.toString(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                    continue;
                }
                doc.add((Fieldable)new Field(key.toString(), values.toString(), Field.Store.YES, Field.Index.UN_TOKENIZED));
            }
        }
    }

    private void addFieldsToParsedObject(Document doc, ParsedObject o) {
        try {
            MultiValueMap multiKeywords = new MultiValueMap();
            MultiValueMap multiFields = new MultiValueMap();
            HashMap fieldMap = new HashMap();
            Field classNameField = doc.getField("fieldname.className");
            if (classNameField != null) {
                String className = classNameField.stringValue();
                o.setClassName(className);
                ObjectHandler handler = this.handlerFactory.getHandler(className);
                Set fields = handler.getFields();
                this.addFieldsToMap(doc, fields, (Map)multiFields);
                this.addFieldsToMap(doc, fields, fieldMap);
                Set keywords = handler.getKeywords();
                this.addFieldsToMap(doc, keywords, (Map)multiKeywords);
            }
            o.setKeywordsMap((Map)multiKeywords);
            o.setFields((Map)multiFields);
            o.setFields(fieldMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addFieldsToMap(Document doc, Set fieldNames, Map fields) {
        for (String fieldName : fieldNames) {
            Field[] docFields = doc.getFields(fieldName);
            if (docFields == null) continue;
            for (int i = 0; i < docFields.length; ++i) {
                Field field = docFields[i];
                if (field == null) continue;
                String value = field.stringValue();
                fields.put(fieldName, value);
            }
        }
    }
}

