/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.net.URL;
import org.apache.jetspeed.components.util.system.ClassLoaderSystemResourceUtilImpl;
import org.apache.jetspeed.security.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(BaseAuthenticationProvider.class);
    private String providerName;
    private String providerDescription;

    public BaseAuthenticationProvider(String providerName, String providerDescription) {
        this.providerName = providerName;
        this.providerDescription = providerDescription;
    }

    public BaseAuthenticationProvider(String providerName, String providerDescription, String loginConfig) {
        this(providerName, providerDescription);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ClassLoaderSystemResourceUtilImpl resourceUtil = new ClassLoaderSystemResourceUtilImpl(cl);
        URL loginConfigUrl = null;
        try {
            loginConfigUrl = resourceUtil.getURL(loginConfig);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not locate the login config.  Bad URL. " + e.toString());
        }
        if (null != loginConfigUrl) {
            if (log.isDebugEnabled()) {
                log.debug("java.security.auth.login.config = " + loginConfigUrl.toString());
            }
            System.setProperty("java.security.auth.login.config", loginConfigUrl.toString());
        }
    }

    public String getProviderDescription() {
        return this.providerDescription;
    }

    public void setProviderDescription(String providerDescription) {
        this.providerDescription = providerDescription;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }
}

