/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import org.apache.jetspeed.security.AuthenticatedUser;
import org.apache.jetspeed.security.AuthenticatedUserImpl;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserCredential;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.impl.BaseAuthenticationProvider;
import org.apache.jetspeed.security.impl.UserCredentialImpl;
import org.apache.jetspeed.security.spi.UserPasswordCredentialManager;

public class DefaultAuthenticationProvider
extends BaseAuthenticationProvider {
    private UserPasswordCredentialManager upcm;
    private UserManager um;

    public DefaultAuthenticationProvider(String providerName, String providerDescription, UserPasswordCredentialManager upcm, UserManager um) {
        super(providerName, providerDescription);
        this.upcm = upcm;
        this.um = um;
    }

    public DefaultAuthenticationProvider(String providerName, String providerDescription, String loginConfig, UserPasswordCredentialManager upcm, UserManager um) {
        super(providerName, providerDescription, loginConfig);
        this.upcm = upcm;
        this.um = um;
    }

    public AuthenticatedUser authenticate(String userName, String password) throws SecurityException {
        PasswordCredential credential = this.upcm.getAuthenticatedPasswordCredential(userName, password);
        User user = credential.getUser();
        if (user == null) {
            user = this.um.getUser(credential.getUserName());
        }
        return new AuthenticatedUserImpl(user, (UserCredential)new UserCredentialImpl((UserCredential)credential));
    }
}

