/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.security.mapping.model.Attribute;
import org.apache.jetspeed.security.mapping.model.AttributeDef;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.apache.jetspeed.security.mapping.model.impl.AttributeImpl;
import org.springframework.ldap.core.DistinguishedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityImpl
implements Entity {
    private Map<String, Attribute> nameToAttributeMap = new HashMap<String, Attribute>();
    private final Map<String, AttributeDef> allowedAttributes;
    private String id;
    private String internalId;
    private String type;
    private boolean live;

    public EntityImpl(String type, String id, Map<String, AttributeDef> allowedAttributes) {
        this.type = type;
        this.id = id;
        this.allowedAttributes = allowedAttributes;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean isLive() {
        return this.live;
    }

    @Override
    public void setLive(boolean live) {
        this.live = live;
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.getAttribute(name, false);
    }

    @Override
    public Attribute getAttribute(String name, boolean create) {
        AttributeDef def;
        Attribute attr = this.nameToAttributeMap.get(name);
        if (attr == null && create && (def = this.allowedAttributes.get(name)) != null) {
            attr = new AttributeImpl(def);
            this.nameToAttributeMap.put(name, attr);
            if (def.isMultiValue()) {
                attr.setValues(new ArrayList<String>());
            }
        }
        return attr;
    }

    @Override
    public Collection<AttributeDef> getAttributeDefinitions() {
        return this.allowedAttributes.values();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setAttribute(String name, String value) {
        Attribute attr = this.nameToAttributeMap.get(name);
        if (attr == null) {
            AttributeDef def = this.allowedAttributes.get(name);
            if (def == null) {
                return;
            }
            if (def.isMultiValue()) {
                return;
            }
            attr = new AttributeImpl(def);
            this.nameToAttributeMap.put(name, attr);
        }
        attr.setValue(value);
    }

    @Override
    public void setAttribute(String name, Collection<String> values) {
        Attribute attr = this.nameToAttributeMap.get(name);
        if (attr == null) {
            AttributeDef def = this.allowedAttributes.get(name);
            if (def == null) {
                return;
            }
            if (!def.isMultiValue()) {
                return;
            }
            attr = new AttributeImpl(def);
            this.nameToAttributeMap.put(name, attr);
        }
        attr.setValues(values);
    }

    @Override
    public void setAttributes(Set<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            this.nameToAttributeMap.put(attribute.getName(), attribute);
        }
    }

    @Override
    public String getInternalId() {
        return this.internalId;
    }

    @Override
    public void setInternalId(String internalId) {
        if (internalId != null) {
            internalId = new DistinguishedName(internalId).toCompactString();
        }
        this.internalId = internalId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.internalId == null ? 0 : this.internalId.hashCode());
        result = 31 * result + (this.nameToAttributeMap == null ? 0 : ((Object)this.nameToAttributeMap).hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityImpl other = (EntityImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equalsIgnoreCase(other.id)) {
            return false;
        }
        if (this.internalId == null ? other.internalId != null : !this.internalId.equalsIgnoreCase(other.internalId)) {
            return false;
        }
        if (this.nameToAttributeMap == null ? other.nameToAttributeMap != null : !((Object)this.nameToAttributeMap).equals(other.nameToAttributeMap)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Entity of type '");
        sb.append(this.getType());
        sb.append("'\nid=");
        sb.append(this.getId());
        sb.append("\ninternalId=");
        sb.append(this.getInternalId());
        sb.append("\nAmount of attributes: ");
        sb.append(this.nameToAttributeMap.values().size());
        sb.append("\n");
        for (Attribute attr : this.nameToAttributeMap.values()) {
            sb.append("attribute: ");
            sb.append(attr.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

