/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.serializer.AbstractJetspeedComponentSerializer;
import org.apache.jetspeed.serializer.SerializerException;
import org.apache.jetspeed.serializer.objects.JSSSOSite;
import org.apache.jetspeed.serializer.objects.JSSSOSiteRemoteUser;
import org.apache.jetspeed.serializer.objects.JSSSOSites;
import org.apache.jetspeed.serializer.objects.JSSnapshot;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOManager;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.SSOUser;
import org.apache.jetspeed.sso.impl.SSOUtils;
import org.slf4j.Logger;

public class JetspeedSSOSerializer
extends AbstractJetspeedComponentSerializer {
    private SSOManager ssoManager;
    private GroupManager groupManager;
    private UserManager userManager;

    public JetspeedSSOSerializer(SSOManager ssoManager, GroupManager groupManager, UserManager userManager) {
        this.ssoManager = ssoManager;
        this.groupManager = groupManager;
        this.userManager = userManager;
    }

    protected void deleteData(Map settings, Logger log) throws SerializerException {
        if (JetspeedSSOSerializer.isSettingSet((Map)settings, (String)"process_sso")) {
            log.info("deleting SSO sites, principals, and security domains");
        }
    }

    protected void processExport(JSSnapshot data, Map settings, Logger log) throws SerializerException {
        if (JetspeedSSOSerializer.isSettingSet((Map)settings, (String)"process_sso")) {
            log.info("collecting SSO sites, principals, and security domains");
            this.exportSSOSites(data, settings, log);
        }
    }

    protected void processImport(JSSnapshot data, Map settings, Logger log) throws SerializerException {
        if (JetspeedSSOSerializer.isSettingSet((Map)settings, (String)"process_sso")) {
            log.info("creating SSO sites, principals, and security domains");
            this.recreateSSOSites(data, settings, log);
        }
    }

    private void deleteSSOSites(Map settings, Logger log) throws SerializerException {
        Iterator list = null;
        try {
            list = new ArrayList(this.ssoManager.getSites("")).iterator();
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"SSOSites", e.getMessage()}));
        }
        while (list.hasNext()) {
            try {
                SSOSite s = (SSOSite)list.next();
                this.ssoManager.removeSite(s);
            }
            catch (Exception e) {
                throw new SerializerException((Throwable)e);
            }
        }
    }

    private JSSSOSite createSSOSite(SSOSite s) throws SSOException {
        JSSSOSite site = new JSSSOSite();
        site.setName(s.getName());
        site.setSiteURL(s.getURL());
        site.setAllowUserSet(s.isAllowUserSet());
        site.setCertificateRequired(s.isCertificateRequired());
        site.setChallengeResponseAuthentication(s.isChallengeResponseAuthentication());
        site.setRealm(s.getRealm());
        site.setFormAuthentication(s.isFormAuthentication());
        site.setFormUserField(s.getFormUserField());
        site.setFormPwdField(s.getFormPwdField());
        for (SSOUser ru : this.ssoManager.getUsersForSite(s)) {
            PasswordCredential ruCredential = this.ssoManager.getCredentials(ru);
            if (ruCredential == null) continue;
            String ruName = ru.getName();
            String rupType = null;
            String rupName = null;
            Collection ruPrincipals = this.ssoManager.getPortalPrincipals(ru);
            if (ruPrincipals != null && !ruPrincipals.isEmpty()) {
                JetspeedPrincipal rup = (JetspeedPrincipal)ruPrincipals.iterator().next();
                rupName = rup.getName();
                if (rup.getType().getName().equals("user")) {
                    rupType = "user";
                } else if (rup.getType().getName().equals("group")) {
                    rupType = "group";
                }
            }
            if (rupName == null || rupType == null) continue;
            String ruPassword = SSOUtils.scramble(ruCredential.getPassword());
            JSSSOSiteRemoteUser siteRemoteUser = new JSSSOSiteRemoteUser();
            siteRemoteUser.setPrincipalName(rupName);
            siteRemoteUser.setPrincipalType(rupType);
            siteRemoteUser.setUserCredential(ruName, ruPassword.toCharArray());
            site.addRemoteUser(siteRemoteUser);
        }
        return site;
    }

    private void exportSSOSites(JSSnapshot data, Map settings, Logger log) throws SerializerException {
        HashMap<String, JSSSOSite> ssoSitesMap = new HashMap<String, JSSSOSite>();
        Iterator list = null;
        try {
            list = this.ssoManager.getSites("").iterator();
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"SSOSites", e.getMessage()}));
        }
        while (list.hasNext()) {
            try {
                SSOSite s = (SSOSite)list.next();
                if (ssoSitesMap.containsKey(s.getURL())) continue;
                JSSSOSite site = this.createSSOSite(s);
                ssoSitesMap.put(site.getSiteURL(), site);
                data.getSSOSites().add((Object)site);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"SSOSites", e.getMessage()}));
            }
        }
    }

    private SSOSite recreateSSOSite(JSSSOSite site, SSOSite s) throws SerializerException, SSOException, SecurityException {
        if (s != null) {
            this.ssoManager.removeSite(s);
        }
        s = this.ssoManager.newSite(site.getName(), site.getSiteURL());
        s = this.ssoManager.addSite(s);
        s.setAllowUserSet(site.isAllowUserSet());
        s.setCertificateRequired(site.isCertificateRequired());
        s.setChallengeResponseAuthentication(site.isChallengeResponseAuthentication());
        s.setRealm(site.getRealm());
        s.setFormAuthentication(site.isFormAuthentication());
        s.setFormUserField(site.getFormUserField());
        s.setFormPwdField(site.getFormPwdField());
        if (site.getRemoteUsers() != null) {
            for (JSSSOSiteRemoteUser rUser : site.getRemoteUsers()) {
                if (rUser.getPassword() == null) continue;
                String pName = rUser.getPrincipalName();
                String pType = rUser.getPrincipalType();
                User principal = null;
                if (pType.equals("user")) {
                    principal = this.userManager.getUser(pName);
                } else if (pType.equals("group")) {
                    principal = this.groupManager.getGroup(pName);
                }
                if (principal != null) {
                    String rName = rUser.getName();
                    String rPassword = new String(rUser.getPassword());
                    this.ssoManager.addUser(s, (JetspeedPrincipal)principal, rName, SSOUtils.unscramble(rPassword));
                    continue;
                }
                throw new IllegalArgumentException("Cannot lookup or create SSO remote user for principal " + pType + ":" + pName);
            }
        }
        return s;
    }

    private void recreateSSOSites(JSSnapshot data, Map settings, Logger log) throws SerializerException {
        log.debug("recreateSSOSites - processing");
        JSSSOSites sites = data.getSSOSites();
        if (sites != null && sites.size() > 0) {
            for (JSSSOSite site : sites) {
                try {
                    SSOSite s = this.ssoManager.getSiteByUrl(site.getSiteURL());
                    if (s != null && !JetspeedSSOSerializer.isSettingSet((Map)settings, (String)"overwrite_existing")) continue;
                    s = this.recreateSSOSite(site, s);
                    this.ssoManager.updateSite(s);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"SSOSite", (Object)e.getLocalizedMessage()));
                }
            }
        } else {
            log.debug("NO SSO SITES?????");
        }
        log.debug("recreateSSOSites - done");
    }
}

