/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.sso.spi.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.SSOUser;
import org.apache.jetspeed.sso.impl.SSOSiteImpl;
import org.apache.jetspeed.sso.spi.SSOSiteManagerSPI;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.ObjectRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedPersistentSSOSiteManager
extends InitablePersistenceBrokerDaoSupport
implements SSOSiteManagerSPI {
    private static final Logger log = LoggerFactory.getLogger(JetspeedPersistentSSOSiteManager.class);
    private Hashtable<String, SSOSite> mapSiteNameIndex = new Hashtable();
    private Hashtable<String, SSOSite> mapSiteUrlIndex = new Hashtable();
    private Hashtable<Long, SSOSite> mapSiteDomainIndex = new Hashtable();

    public JetspeedPersistentSSOSiteManager(String repositoryPath) throws ClassNotFoundException {
        super(repositoryPath);
    }

    @Override
    public SSOSite add(SSOSite ssoSite) throws SSOException {
        try {
            this.getPersistenceBrokerTemplate().store((Object)ssoSite);
            this.cacheSite(ssoSite);
            return ssoSite;
        }
        catch (Exception e) {
            String msg = "Unable to add SSO Site: " + ssoSite.getName();
            log.error(msg, (Throwable)e);
            throw new SSOException(msg, (Throwable)e);
        }
    }

    public boolean exists(String siteUrl) {
        return this.getByUrl(siteUrl) != null;
    }

    @Override
    public SSOSite getById(int id) {
        try {
            return (SSOSite)this.getPersistenceBrokerTemplate().getObjectById(SSOSiteImpl.class, (Object)id);
        }
        catch (ObjectRetrievalFailureException ore) {
            return null;
        }
    }

    @Override
    public SSOSite getByName(String siteName) {
        Criteria filter = new Criteria();
        filter.addEqualTo("name", (Object)siteName);
        QueryByCriteria query = QueryFactory.newQuery(SSOSiteImpl.class, (Criteria)filter);
        SSOSite site = (SSOSite)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (site != null) {
            this.cacheSite(site);
        }
        return site;
    }

    @Override
    public SSOSite getByUrl(String siteUrl) {
        Criteria filter = new Criteria();
        filter.addEqualTo("url", (Object)siteUrl);
        QueryByCriteria query = QueryFactory.newQuery(SSOSiteImpl.class, (Criteria)filter);
        SSOSite site = (SSOSite)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (site != null) {
            this.cacheSite(site);
        }
        return site;
    }

    @Override
    public SSOSite getSite(SSOUser ssoUser) {
        Collection<SSOSite> sitesForUser = this.getSites(Arrays.asList(ssoUser));
        if (sitesForUser.size() == 1) {
            return sitesForUser.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<SSOSite> getSites(String filter) {
        Criteria finalCriteria = new Criteria();
        if (StringUtils.isNotEmpty((String)filter)) {
            filter = filter.replaceAll("%", "\\%");
            filter = "%" + filter + "%";
            Criteria urlCriteria = new Criteria();
            urlCriteria.addLike((Object)"url", (Object)filter);
            finalCriteria.addOrCriteria(urlCriteria);
            Criteria nameCriteria = new Criteria();
            nameCriteria.addLike((Object)"name", (Object)filter);
            finalCriteria.addOrCriteria(nameCriteria);
        }
        QueryByCriteria query = QueryFactory.newQuery(SSOSiteImpl.class, (Criteria)finalCriteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public Collection<SSOSite> getSites(Collection<SSOUser> users) {
        if (users.size() > 0) {
            Criteria queryCriteria = new Criteria();
            for (SSOUser u : users) {
                Criteria domainCriteria = new Criteria();
                domainCriteria.addEqualTo("securityDomainId", (Object)u.getDomainId());
                queryCriteria.addOrCriteria(domainCriteria);
            }
            QueryByCriteria query = QueryFactory.newQuery(SSOSiteImpl.class, (Criteria)queryCriteria);
            query.addOrderByAscending("name");
            return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void remove(SSOSite site) throws SSOException {
        try {
            this.getPersistenceBrokerTemplate().delete((Object)site);
            this.removeSiteFromCache(site);
        }
        catch (Exception e) {
            String msg = "Unable to remove SSO Site: " + site.getName();
            log.error(msg, (Throwable)e);
            throw new SSOException(msg, (Throwable)e);
        }
    }

    @Override
    public void update(SSOSite site) throws SSOException {
        try {
            this.getPersistenceBrokerTemplate().store((Object)site);
            this.cacheSite(site);
        }
        catch (Exception e) {
            String msg = "Unable to remove SSO Site: " + site.getName();
            log.error(msg, (Throwable)e);
            throw new SSOException(msg, (Throwable)e);
        }
    }

    protected void cacheSite(SSOSite site) {
        if (this.getCachedSiteByDomainId(site.getSecurityDomainId()) != null) {
            this.removeSiteFromCache(site);
        }
        this.mapSiteUrlIndex.put(site.getURL(), site);
        this.mapSiteDomainIndex.put(site.getSecurityDomainId(), site);
        this.mapSiteNameIndex.put(site.getName(), site);
    }

    protected SSOSite getCachedSiteByUrl(String url) {
        return this.mapSiteUrlIndex.get(url);
    }

    protected SSOSite getCachedSiteByDomainId(Long domainId) {
        return this.mapSiteUrlIndex.get(domainId);
    }

    protected SSOSite getCachedSiteByName(String name) {
        return this.mapSiteNameIndex.get(name);
    }

    protected void removeSiteFromCache(SSOSite site) {
        this.mapSiteUrlIndex.remove(site.getURL());
        this.mapSiteDomainIndex.remove(site.getSecurityDomainId());
    }
}

