/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.encryption.internal;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.javax.annotation.Nullable;

@Singleton
public class JCECrypto
implements Crypto {
    private final KeyPairGenerator rsaKeyPairGenerator;
    private final KeyFactory rsaKeyFactory;
    private final CertificateFactory certFactory;
    private final Provider provider;
    private static final String HmacSHA256 = "HmacSHA256";
    private static final String HmacSHA1 = "HmacSHA1";

    @Inject
    public JCECrypto() throws NoSuchAlgorithmException, CertificateException {
        this(null);
    }

    public JCECrypto(@Nullable Provider provider) throws NoSuchAlgorithmException, CertificateException {
        this.rsaKeyPairGenerator = provider == null ? KeyPairGenerator.getInstance("RSA") : KeyPairGenerator.getInstance("RSA", provider);
        this.rsaKeyFactory = provider == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", provider);
        this.certFactory = provider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
        this.provider = provider;
    }

    @Override
    public Mac hmac(String algorithm, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = null;
        if (this.provider != null) {
            try {
                mac = Mac.getInstance(algorithm, this.provider);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mac == null) {
            mac = Mac.getInstance(algorithm);
        }
        SecretKeySpec signingKey = new SecretKeySpec(key, algorithm);
        mac.init(signingKey);
        return mac;
    }

    @Override
    public Cipher cipher(String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return this.provider == null ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, this.provider);
    }

    @Override
    public Mac hmacSHA1(byte[] key) throws InvalidKeyException {
        try {
            return this.hmac(HmacSHA1, key);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("HmacSHA1 must be supported", e);
        }
    }

    @Override
    public Mac hmacSHA256(byte[] key) throws InvalidKeyException {
        try {
            return this.hmac(HmacSHA256, key);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("HmacSHA256 must be supported", e);
        }
    }

    @Override
    public CertificateFactory certFactory() {
        return this.certFactory;
    }

    @Override
    public KeyFactory rsaKeyFactory() {
        return this.rsaKeyFactory;
    }

    @Override
    public KeyPairGenerator rsaKeyPairGenerator() {
        return this.rsaKeyPairGenerator;
    }
}

