/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;

@Singleton
public class UnwrapOnlyJsonValue<T>
implements Function<HttpResponse, T> {
    private final ParseJson<Map<String, T>> json;

    @Inject
    UnwrapOnlyJsonValue(ParseJson<Map<String, T>> json) {
        this.json = json;
    }

    @Override
    public T apply(HttpResponse arg0) {
        Map<String, T> map = this.json.apply(arg0);
        return Iterables.getOnlyElement(map.values());
    }
}

