/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Provider;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.blobstore.functions.BlobToObjectMetadata;
import org.jclouds.s3.blobstore.functions.BucketToResourceList;
import org.jclouds.s3.blobstore.functions.ContainerToBucketListOptions;
import org.jclouds.s3.blobstore.functions.ObjectToBlob;
import org.jclouds.s3.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.ListMultipartUploadResponse;
import org.jclouds.s3.domain.ListMultipartUploadsResponse;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.s3.util.S3Utils;
import org.jclouds.util.Predicates2;

@Singleton
public class S3BlobStore
extends BaseBlobStore {
    private final S3Client sync;
    private final Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>> convertBucketsToStorageMetadata;
    private final ContainerToBucketListOptions container2BucketListOptions;
    private final BucketToResourceList bucket2ResourceList;
    private final ObjectToBlob object2Blob;
    private final BlobToObject blob2Object;
    private final ObjectToBlobMetadata object2BlobMd;
    private final BlobToObjectMetadata blob2ObjectMetadata;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;

    @Inject
    protected S3BlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, PayloadSlicer slicer, S3Client sync, Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>> convertBucketsToStorageMetadata, ContainerToBucketListOptions container2BucketListOptions, BucketToResourceList bucket2ResourceList, ObjectToBlob object2Blob, BlobToHttpGetOptions blob2ObjectGetOptions, BlobToObject blob2Object, BlobToObjectMetadata blob2ObjectMetadata, ObjectToBlobMetadata object2BlobMd, Provider<FetchBlobMetadata> fetchBlobMetadataProvider) {
        super(context, blobUtils, defaultLocation, locations, slicer);
        this.blob2ObjectGetOptions = Preconditions.checkNotNull(blob2ObjectGetOptions, "blob2ObjectGetOptions");
        this.sync = Preconditions.checkNotNull(sync, "sync");
        this.convertBucketsToStorageMetadata = Preconditions.checkNotNull(convertBucketsToStorageMetadata, "convertBucketsToStorageMetadata");
        this.container2BucketListOptions = Preconditions.checkNotNull(container2BucketListOptions, "container2BucketListOptions");
        this.bucket2ResourceList = Preconditions.checkNotNull(bucket2ResourceList, "bucket2ResourceList");
        this.object2Blob = Preconditions.checkNotNull(object2Blob, "object2Blob");
        this.blob2Object = Preconditions.checkNotNull(blob2Object, "blob2Object");
        this.object2BlobMd = Preconditions.checkNotNull(object2BlobMd, "object2BlobMd");
        this.blob2ObjectMetadata = Preconditions.checkNotNull(blob2ObjectMetadata, "blob2ObjectMetadata");
        this.fetchBlobMetadataProvider = Preconditions.checkNotNull(fetchBlobMetadataProvider, "fetchBlobMetadataProvider");
    }

    @Override
    public PageSet<? extends StorageMetadata> list() {
        return this.convertBucketsToStorageMetadata.apply(this.sync.listOwnedBuckets());
    }

    @Override
    public boolean containerExists(String container) {
        return this.sync.bucketExists(container);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container) {
        return this.createContainerInLocation(location, container, CreateContainerOptions.NONE);
    }

    @Override
    public ContainerAccess getContainerAccess(String container) {
        AccessControlList acl = this.sync.getBucketACL(container);
        if (acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")) {
            return ContainerAccess.PUBLIC_READ;
        }
        return ContainerAccess.PRIVATE;
    }

    @Override
    public void setContainerAccess(String container, ContainerAccess access) {
        CannedAccessPolicy acl = CannedAccessPolicy.PRIVATE;
        if (access == ContainerAccess.PUBLIC_READ) {
            acl = CannedAccessPolicy.PUBLIC_READ;
        }
        this.sync.updateBucketCannedACL(container, acl);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        ListBucketOptions httpOptions = this.container2BucketListOptions.apply(options);
        PageSet<? extends StorageMetadata> list = this.bucket2ResourceList.apply(this.sync.listBucket(container, httpOptions));
        return options.isDetailed() ? this.fetchBlobMetadataProvider.get().setContainerName(container).apply(list) : list;
    }

    @Override
    protected void deletePathAndEnsureGone(String path) {
        Preconditions.checkState(Predicates2.retry(new Predicate<String>(){

            @Override
            public boolean apply(String in) {
                try {
                    S3BlobStore.this.clearContainer(in);
                    return S3BlobStore.this.sync.deleteBucketIfEmpty(in);
                }
                catch (ContainerNotFoundException e) {
                    return true;
                }
            }
        }, 30000L).apply(path), "%s still exists after deleting!", (Object)path);
    }

    @Override
    public boolean blobExists(String container, String key) {
        return this.sync.objectExists(container, key);
    }

    @Override
    public BlobMetadata blobMetadata(String container, String key) {
        return this.object2BlobMd.apply(this.sync.headObject(container, key));
    }

    @Override
    public Blob getBlob(String container, String key, GetOptions optionsList) {
        org.jclouds.http.options.GetOptions httpOptions = this.blob2ObjectGetOptions.apply(optionsList);
        return this.object2Blob.apply(this.sync.getObject(container, key, httpOptions));
    }

    @Override
    public String putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, PutOptions.NONE);
    }

    @Override
    public String putBlob(String container, Blob blob, PutOptions overrides) {
        if (overrides.isMultipart()) {
            return this.putMultipartBlob(container, blob, overrides);
        }
        PutObjectOptions options = new PutObjectOptions();
        if (overrides.getBlobAccess() == BlobAccess.PUBLIC_READ) {
            options = options.withAcl(CannedAccessPolicy.PUBLIC_READ);
        }
        return this.sync.putObject(container, this.blob2Object.apply(blob), options);
    }

    @Override
    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        Map<String, String> userMetadata;
        ContentMetadata contentMetadata;
        CopyObjectOptions s3Options = new CopyObjectOptions();
        if (options.ifMatch() != null) {
            s3Options.ifSourceETagMatches(options.ifMatch());
        }
        if (options.ifNoneMatch() != null) {
            s3Options.ifSourceETagDoesntMatch(options.ifNoneMatch());
        }
        if (options.ifModifiedSince() != null) {
            s3Options.ifSourceModifiedSince(options.ifModifiedSince());
        }
        if (options.ifUnmodifiedSince() != null) {
            s3Options.ifSourceUnmodifiedSince(options.ifUnmodifiedSince());
        }
        if ((contentMetadata = options.contentMetadata()) != null) {
            String contentType;
            String contentLanguage;
            String contentEncoding;
            String contentDisposition;
            String cacheControl = contentMetadata.getCacheControl();
            if (cacheControl != null) {
                s3Options.cacheControl(cacheControl);
            }
            if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
                s3Options.contentDisposition(contentDisposition);
            }
            if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
                s3Options.contentEncoding(contentEncoding);
            }
            if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
                s3Options.contentLanguage(contentLanguage);
            }
            if ((contentType = contentMetadata.getContentType()) != null) {
                s3Options.contentType(contentType);
            }
        }
        if ((userMetadata = options.userMetadata()) != null) {
            s3Options.overrideMetadataWith(userMetadata);
        }
        return this.sync.copyObject(fromContainer, fromName, toContainer, toName, s3Options).getETag();
    }

    @Override
    public void removeBlob(String container, String key) {
        this.sync.deleteObject(container, key);
    }

    @Override
    public void removeBlobs(String container, Iterable<String> keys) {
        for (List<String> partition : Iterables.partition(keys, 1000)) {
            this.sync.deleteObjects(container, partition);
        }
    }

    @Override
    public BlobAccess getBlobAccess(String container, String name) {
        AccessControlList acl = this.sync.getObjectACL(container, name);
        if (acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")) {
            return BlobAccess.PUBLIC_READ;
        }
        return BlobAccess.PRIVATE;
    }

    @Override
    public void setBlobAccess(String container, String name, BlobAccess access) {
        CannedAccessPolicy acl = CannedAccessPolicy.PRIVATE;
        if (access == BlobAccess.PUBLIC_READ) {
            acl = CannedAccessPolicy.PUBLIC_READ;
        }
        this.sync.updateObjectCannedACL(container, name, acl);
    }

    @Override
    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions overrides) {
        PutObjectOptions options = new PutObjectOptions();
        if (overrides.getBlobAccess() == BlobAccess.PUBLIC_READ) {
            options = options.withAcl(CannedAccessPolicy.PUBLIC_READ);
        }
        String id = this.sync.initiateMultipartUpload(container, this.blob2ObjectMetadata.apply(blobMetadata), options);
        return MultipartUpload.create(container, blobMetadata.getName(), id, blobMetadata, overrides);
    }

    @Override
    public void abortMultipartUpload(MultipartUpload mpu) {
        this.sync.abortMultipartUpload(mpu.containerName(), mpu.blobName(), mpu.id());
    }

    @Override
    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        ImmutableMap.Builder<Integer, String> builder = ImmutableMap.builder();
        for (MultipartPart part : parts) {
            builder.put(part.partNumber(), part.partETag());
        }
        return this.sync.completeMultipartUpload(mpu.containerName(), mpu.blobName(), mpu.id(), builder.build());
    }

    @Override
    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        long partSize = payload.getContentMetadata().getContentLength();
        String eTag = this.sync.uploadPart(mpu.containerName(), mpu.blobName(), partNumber, mpu.id(), payload);
        Date lastModified = null;
        return MultipartPart.create(partNumber, partSize, eTag, lastModified);
    }

    @Override
    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        ImmutableList.Builder parts = ImmutableList.builder();
        Map<Integer, ListMultipartUploadResponse> s3Parts = this.sync.listMultipartPartsFull(mpu.containerName(), mpu.blobName(), mpu.id());
        for (Map.Entry<Integer, ListMultipartUploadResponse> entry : s3Parts.entrySet()) {
            ListMultipartUploadResponse response = entry.getValue();
            parts.add(MultipartPart.create(entry.getKey(), response.size(), response.eTag(), response.lastModified()));
        }
        return parts.build();
    }

    @Override
    public List<MultipartUpload> listMultipartUploads(String container) {
        ListMultipartUploadsResponse response;
        ImmutableList.Builder builder = ImmutableList.builder();
        String keyMarker = null;
        String uploadIdMarker = null;
        do {
            response = this.sync.listMultipartUploads(container, null, null, keyMarker, null, uploadIdMarker);
            for (ListMultipartUploadsResponse.Upload upload : response.uploads()) {
                builder.add(MultipartUpload.create(container, upload.key(), upload.uploadId(), null, null));
            }
            keyMarker = response.keyMarker();
            uploadIdMarker = response.uploadIdMarker();
        } while (!response.uploads().isEmpty() && keyMarker != null && uploadIdMarker != null);
        return builder.build();
    }

    @Override
    public long getMinimumMultipartPartSize() {
        return 0x500000L;
    }

    @Override
    public long getMaximumMultipartPartSize() {
        return 0x140000000L;
    }

    @Override
    public int getMaximumNumberOfParts() {
        return 10000;
    }

    @Override
    protected boolean deleteAndVerifyContainerGone(String container) {
        return S3Utils.deleteAndVerifyContainerGone(this.sync, container);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        PutBucketOptions putBucketOptions = new PutBucketOptions();
        if (options.isPublicRead()) {
            putBucketOptions.withBucketAcl(CannedAccessPolicy.PUBLIC_READ);
        }
        location = location != null ? location : (Location)this.defaultLocation.get();
        return this.sync.putBucketInRegion(location.getId(), container, putBucketOptions);
    }
}

