/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.jclouds.glacier.domain.GlacierError;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;

public class GlacierResponseException
extends HttpResponseException {
    private static final long serialVersionUID = 1L;
    private final GlacierError error;

    public GlacierResponseException(HttpCommand command, HttpResponse response, GlacierError error) {
        super("request " + command.getCurrentRequest().getRequestLine() + " failed with code " + response.getStatusCode() + ", error: " + error.toString(), command, response);
        this.error = Preconditions.checkNotNull(error, "error");
    }

    public GlacierError getError() {
        return this.error;
    }
}

