/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import java.beans.ConstructorProperties;
import java.util.Date;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.jcloud.shade.com.google.gson.annotations.SerializedName;
import org.jclouds.javax.annotation.Nullable;

public class VaultMetadata
implements Comparable<VaultMetadata> {
    @SerializedName(value="VaultName")
    private final String vaultName;
    @SerializedName(value="VaultARN")
    private final String vaultARN;
    @SerializedName(value="CreationDate")
    private final Date creationDate;
    @SerializedName(value="LastInventoryDate")
    private final Date lastInventoryDate;
    @SerializedName(value="NumberOfArchives")
    private final long numberOfArchives;
    @SerializedName(value="SizeInBytes")
    private final long sizeInBytes;

    @ConstructorProperties(value={"VaultName", "VaultARN", "CreationDate", "LastInventoryDate", "NumberOfArchives", "SizeInBytes"})
    public VaultMetadata(String vaultName, String vaultARN, Date creationDate, @Nullable Date lastInventoryDate, long numberOfArchives, long sizeInBytes) {
        this.vaultName = Preconditions.checkNotNull(vaultName, "vaultName");
        this.vaultARN = Preconditions.checkNotNull(vaultARN, "vaultARN");
        this.creationDate = (Date)Preconditions.checkNotNull(creationDate, "creationDate").clone();
        this.lastInventoryDate = lastInventoryDate;
        this.numberOfArchives = numberOfArchives;
        this.sizeInBytes = sizeInBytes;
    }

    public String getVaultName() {
        return this.vaultName;
    }

    public String getVaultARN() {
        return this.vaultARN;
    }

    public Date getCreationDate() {
        return (Date)this.creationDate.clone();
    }

    public Date getLastInventoryDate() {
        return this.lastInventoryDate;
    }

    public long getNumberOfArchives() {
        return this.numberOfArchives;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int hashCode() {
        return Objects.hashCode(this.vaultName, this.vaultARN, this.creationDate, this.lastInventoryDate, this.numberOfArchives, this.sizeInBytes);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VaultMetadata other = (VaultMetadata)obj;
        return Objects.equal(this.vaultName, other.vaultName) && Objects.equal(this.vaultARN, other.vaultARN) && Objects.equal(this.creationDate, other.creationDate) && Objects.equal(this.lastInventoryDate, other.lastInventoryDate) && Objects.equal(this.numberOfArchives, other.numberOfArchives) && Objects.equal(this.sizeInBytes, other.sizeInBytes);
    }

    public String toString() {
        return "VaultMetadata [vaultName=" + this.vaultName + ", vaultARN=" + this.vaultARN + ", creationDate=" + this.creationDate + ", lastInventoryDate=" + this.lastInventoryDate + ", numberOfArchives=" + this.numberOfArchives + ", sizeInBytes=" + this.sizeInBytes + "]";
    }

    @Override
    public int compareTo(VaultMetadata o) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.vaultName), (Comparable<?>)((Object)o.getVaultName())).result();
    }
}

