/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.predicates.validators;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.inject.Singleton;
import org.jclouds.predicates.Validator;

@Singleton
public final class PartSizeValidator
extends Validator<Long> {
    private static final int MIN_PART_SIZE = 1;
    private static final int MAX_PART_SIZE = 4096;

    @Override
    public void validate(Long partSizeInMB) throws IllegalArgumentException {
        Preconditions.checkNotNull(partSizeInMB, "partSizeInMB");
        Preconditions.checkArgument(partSizeInMB >= 1L && partSizeInMB <= 4096L && Long.bitCount(partSizeInMB) == 1, "partSizeInMB must be a power of 2 between 1 and 4096.");
    }
}

