/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Provider;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.domain.AtmosError;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.filters.SignRequest;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.atmos.reference.AtmosErrorCode;
import org.jclouds.atmos.xml.ErrorHandler;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyAlreadyExistsException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.crypto.Crypto;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.Predicates2;

public class AtmosUtils {
    @Inject
    SignRequest signer;
    @Inject
    ParseSax.Factory factory;
    @Inject
    Provider<ErrorHandler> errorHandlerProvider;

    public AtmosError parseAtmosErrorFromContent(HttpCommand command, HttpResponse response, InputStream content) throws HttpException {
        AtmosError error = (AtmosError)this.factory.create(this.errorHandlerProvider.get()).parse(content);
        if (error.getCode() == AtmosErrorCode.SIGNATURE_MISMATCH.getCode()) {
            error.setStringSigned(this.signer.createStringToSign(command.getCurrentRequest()));
        }
        return error;
    }

    public static String putBlob(AtmosClient sync, Crypto crypto, BlobToObject blob2Object, String container, Blob blob, PutOptions options) {
        URI uri;
        String path = container + "/" + blob.getMetadata().getName();
        AtmosObject object = blob2Object.apply(blob);
        try {
            uri = sync.createFile(container, object, options);
        }
        catch (KeyAlreadyExistsException e) {
            AtmosUtils.deletePathAndEnsureGone(sync, path);
            uri = sync.createFile(container, object, options);
        }
        String objectId = uri.getPath();
        String prefix = "/rest/objects/";
        Preconditions.checkState(objectId.startsWith(prefix), objectId);
        return objectId.substring(prefix.length());
    }

    public static void deletePathAndEnsureGone(final AtmosClient sync, String path) {
        Preconditions.checkState(Predicates2.retry(new Predicate<String>(){

            @Override
            public boolean apply(String in) {
                try {
                    sync.deletePath(in);
                    return !sync.pathExists(in);
                }
                catch (ContainerNotFoundException e) {
                    return true;
                }
            }
        }, 3000L).apply(path), "%s still exists after deleting!", (Object)path);
    }

    public AtmosError parseAtmosErrorFromContent(HttpCommand command, HttpResponse response, String content) throws HttpException {
        return this.parseAtmosErrorFromContent(command, response, new ByteArrayInputStream(content.getBytes()));
    }

    public static String adjustContainerIfDirOptionPresent(String container, ListContainerOptions options) {
        if (options != ListContainerOptions.NONE && options.getDir() != null) {
            container = container + "/" + options.getDir();
        }
        return container;
    }
}

