/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.LedgerOffloader;
import org.apache.bookkeeper.mledger.impl.NullLedgerOffloader;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.commons.collections4.MapUtils;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public class ManagedLedgerConfig {
    private boolean createIfMissing = true;
    private int maxUnackedRangesToPersist = 10000;
    private int maxBatchDeletedIndexToPersist = 10000;
    private boolean persistentUnackedRangesWithMultipleEntriesEnabled = false;
    private boolean deletionAtBatchIndexLevelEnabled = true;
    private int maxUnackedRangesToPersistInMetadataStore = 1000;
    private int maxEntriesPerLedger = 50000;
    private int maxSizePerLedgerMb = 100;
    private int minimumRolloverTimeMs = 0;
    private long maximumRolloverTimeMs = TimeUnit.HOURS.toMillis(4L);
    private int ensembleSize = 3;
    private int writeQuorumSize = 2;
    private int ackQuorumSize = 2;
    private int metadataEnsembleSize = 3;
    private int metadataWriteQuorumSize = 2;
    private int metadataAckQuorumSize = 2;
    private int metadataMaxEntriesPerLedger = 50000;
    private int ledgerRolloverTimeout = 14400;
    private double throttleMarkDelete = 0.0;
    private long retentionTimeMs = 0L;
    private long retentionSizeInMB = 0L;
    private boolean autoSkipNonRecoverableData;
    private boolean lazyCursorRecovery = false;
    private long metadataOperationsTimeoutSeconds = 60L;
    private long readEntryTimeoutSeconds = 120L;
    private long addEntryTimeoutSeconds = 120L;
    private DigestType digestType = DigestType.CRC32C;
    private byte[] password = "".getBytes(StandardCharsets.UTF_8);
    private boolean unackedRangesOpenCacheSetEnabled = true;
    private Class<? extends EnsemblePlacementPolicy> bookKeeperEnsemblePlacementPolicyClassName;
    private Map<String, Object> bookKeeperEnsemblePlacementPolicyProperties;
    private LedgerOffloader ledgerOffloader = NullLedgerOffloader.INSTANCE;
    private int newEntriesCheckDelayInMillis = 10;
    private Clock clock = Clock.systemUTC();
    private ManagedLedgerInterceptor managedLedgerInterceptor;
    private Map<String, String> properties;
    private int inactiveLedgerRollOverTimeMs = 0;
    private boolean cacheEvictionByMarkDeletedPosition = false;
    private int minimumBacklogCursorsForCaching = 0;
    private int minimumBacklogEntriesForCaching = 1000;
    private int maxBacklogBetweenCursorsForCaching = 1000;
    private boolean triggerOffloadOnTopicLoad = false;
    private String shadowSourceName;
    public static final String PROPERTY_SOURCE_TOPIC_KEY = "PULSAR.SHADOW_SOURCE";

    public boolean isCreateIfMissing() {
        return this.createIfMissing;
    }

    public ManagedLedgerConfig setCreateIfMissing(boolean createIfMissing) {
        this.createIfMissing = createIfMissing;
        return this;
    }

    public boolean isLazyCursorRecovery() {
        return this.lazyCursorRecovery;
    }

    public ManagedLedgerConfig setLazyCursorRecovery(boolean lazyCursorRecovery) {
        this.lazyCursorRecovery = lazyCursorRecovery;
        return this;
    }

    public int getMaxEntriesPerLedger() {
        return this.maxEntriesPerLedger;
    }

    public ManagedLedgerConfig setMaxEntriesPerLedger(int maxEntriesPerLedger) {
        this.maxEntriesPerLedger = maxEntriesPerLedger;
        return this;
    }

    public int getMaxSizePerLedgerMb() {
        return this.maxSizePerLedgerMb;
    }

    public ManagedLedgerConfig setMaxSizePerLedgerMb(int maxSizePerLedgerMb) {
        this.maxSizePerLedgerMb = maxSizePerLedgerMb;
        return this;
    }

    public int getMinimumRolloverTimeMs() {
        return this.minimumRolloverTimeMs;
    }

    public void setMinimumRolloverTime(int minimumRolloverTime, TimeUnit unit) {
        this.minimumRolloverTimeMs = (int)unit.toMillis(minimumRolloverTime);
        Preconditions.checkArgument((this.maximumRolloverTimeMs >= (long)this.minimumRolloverTimeMs ? 1 : 0) != 0, (Object)"Minimum rollover time needs to be less than maximum rollover time");
    }

    public long getMaximumRolloverTimeMs() {
        return this.maximumRolloverTimeMs;
    }

    public void setMaximumRolloverTime(int maximumRolloverTime, TimeUnit unit) {
        this.maximumRolloverTimeMs = unit.toMillis(maximumRolloverTime);
        Preconditions.checkArgument((this.maximumRolloverTimeMs >= (long)this.minimumRolloverTimeMs ? 1 : 0) != 0, (Object)"Maximum rollover time needs to be greater than minimum rollover time");
    }

    public int getEnsembleSize() {
        return this.ensembleSize;
    }

    public ManagedLedgerConfig setEnsembleSize(int ensembleSize) {
        this.ensembleSize = ensembleSize;
        return this;
    }

    public int getAckQuorumSize() {
        return this.ackQuorumSize;
    }

    public int getWriteQuorumSize() {
        return this.writeQuorumSize;
    }

    public ManagedLedgerConfig setWriteQuorumSize(int writeQuorumSize) {
        this.writeQuorumSize = writeQuorumSize;
        return this;
    }

    public ManagedLedgerConfig setAckQuorumSize(int ackQuorumSize) {
        this.ackQuorumSize = ackQuorumSize;
        return this;
    }

    public DigestType getDigestType() {
        return this.digestType;
    }

    public ManagedLedgerConfig setDigestType(DigestType digestType) {
        this.digestType = digestType;
        return this;
    }

    public byte[] getPassword() {
        return Arrays.copyOf(this.password, this.password.length);
    }

    public ManagedLedgerConfig setPassword(String password) {
        this.password = password.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public boolean isUnackedRangesOpenCacheSetEnabled() {
        return this.unackedRangesOpenCacheSetEnabled;
    }

    public ManagedLedgerConfig setUnackedRangesOpenCacheSetEnabled(boolean unackedRangesOpenCacheSetEnabled) {
        this.unackedRangesOpenCacheSetEnabled = unackedRangesOpenCacheSetEnabled;
        return this;
    }

    public int getMetadataEnsemblesize() {
        return this.metadataEnsembleSize;
    }

    public ManagedLedgerConfig setMetadataEnsembleSize(int metadataEnsembleSize) {
        this.metadataEnsembleSize = metadataEnsembleSize;
        return this;
    }

    public int getMetadataAckQuorumSize() {
        return this.metadataAckQuorumSize;
    }

    public int getMetadataWriteQuorumSize() {
        return this.metadataWriteQuorumSize;
    }

    public ManagedLedgerConfig setMetadataAckQuorumSize(int metadataAckQuorumSize) {
        this.metadataAckQuorumSize = metadataAckQuorumSize;
        return this;
    }

    public ManagedLedgerConfig setMetadataWriteQuorumSize(int metadataWriteQuorumSize) {
        this.metadataWriteQuorumSize = metadataWriteQuorumSize;
        return this;
    }

    public int getMetadataMaxEntriesPerLedger() {
        return this.metadataMaxEntriesPerLedger;
    }

    public ManagedLedgerConfig setMetadataMaxEntriesPerLedger(int metadataMaxEntriesPerLedger) {
        this.metadataMaxEntriesPerLedger = metadataMaxEntriesPerLedger;
        return this;
    }

    public int getLedgerRolloverTimeout() {
        return this.ledgerRolloverTimeout;
    }

    public ManagedLedgerConfig setLedgerRolloverTimeout(int ledgerRolloverTimeout) {
        this.ledgerRolloverTimeout = ledgerRolloverTimeout;
        return this;
    }

    public double getThrottleMarkDelete() {
        return this.throttleMarkDelete;
    }

    public ManagedLedgerConfig setThrottleMarkDelete(double throttleMarkDelete) {
        Preconditions.checkArgument((throttleMarkDelete >= 0.0 ? 1 : 0) != 0);
        this.throttleMarkDelete = throttleMarkDelete;
        return this;
    }

    public ManagedLedgerConfig setRetentionTime(int retentionTime, TimeUnit unit) {
        this.retentionTimeMs = unit.toMillis(retentionTime);
        return this;
    }

    public long getRetentionTimeMillis() {
        return this.retentionTimeMs;
    }

    public ManagedLedgerConfig setRetentionSizeInMB(long retentionSizeInMB) {
        this.retentionSizeInMB = retentionSizeInMB;
        return this;
    }

    public long getRetentionSizeInMB() {
        return this.retentionSizeInMB;
    }

    public boolean isAutoSkipNonRecoverableData() {
        return this.autoSkipNonRecoverableData;
    }

    public void setAutoSkipNonRecoverableData(boolean skipNonRecoverableData) {
        this.autoSkipNonRecoverableData = skipNonRecoverableData;
    }

    public int getMaxUnackedRangesToPersist() {
        return this.maxUnackedRangesToPersist;
    }

    public int getMaxBatchDeletedIndexToPersist() {
        return this.maxBatchDeletedIndexToPersist;
    }

    public boolean isPersistentUnackedRangesWithMultipleEntriesEnabled() {
        return this.persistentUnackedRangesWithMultipleEntriesEnabled;
    }

    public void setPersistentUnackedRangesWithMultipleEntriesEnabled(boolean multipleEntriesEnabled) {
        this.persistentUnackedRangesWithMultipleEntriesEnabled = multipleEntriesEnabled;
    }

    public ManagedLedgerConfig setMaxUnackedRangesToPersist(int maxUnackedRangesToPersist) {
        this.maxUnackedRangesToPersist = maxUnackedRangesToPersist;
        return this;
    }

    public int getMaxUnackedRangesToPersistInMetadataStore() {
        return this.maxUnackedRangesToPersistInMetadataStore;
    }

    public void setMaxUnackedRangesToPersistInMetadataStore(int maxUnackedRangesToPersistInMetadataStore) {
        this.maxUnackedRangesToPersistInMetadataStore = maxUnackedRangesToPersistInMetadataStore;
    }

    public LedgerOffloader getLedgerOffloader() {
        return this.ledgerOffloader;
    }

    public ManagedLedgerConfig setLedgerOffloader(LedgerOffloader offloader) {
        this.ledgerOffloader = offloader;
        return this;
    }

    public Clock getClock() {
        return this.clock;
    }

    public ManagedLedgerConfig setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public long getMetadataOperationsTimeoutSeconds() {
        return this.metadataOperationsTimeoutSeconds;
    }

    public ManagedLedgerConfig setMetadataOperationsTimeoutSeconds(long metadataOperationsTimeoutSeconds) {
        this.metadataOperationsTimeoutSeconds = metadataOperationsTimeoutSeconds;
        return this;
    }

    public long getReadEntryTimeoutSeconds() {
        return this.readEntryTimeoutSeconds;
    }

    public ManagedLedgerConfig setReadEntryTimeoutSeconds(long readEntryTimeoutSeconds) {
        this.readEntryTimeoutSeconds = readEntryTimeoutSeconds;
        return this;
    }

    public long getAddEntryTimeoutSeconds() {
        return this.addEntryTimeoutSeconds;
    }

    public ManagedLedgerConfig setAddEntryTimeoutSeconds(long addEntryTimeoutSeconds) {
        this.addEntryTimeoutSeconds = addEntryTimeoutSeconds;
        return this;
    }

    public Class<? extends EnsemblePlacementPolicy> getBookKeeperEnsemblePlacementPolicyClassName() {
        return this.bookKeeperEnsemblePlacementPolicyClassName;
    }

    public void setBookKeeperEnsemblePlacementPolicyClassName(Class<? extends EnsemblePlacementPolicy> bookKeeperEnsemblePlacementPolicyClassName) {
        this.bookKeeperEnsemblePlacementPolicyClassName = bookKeeperEnsemblePlacementPolicyClassName;
    }

    public Map<String, Object> getBookKeeperEnsemblePlacementPolicyProperties() {
        return this.bookKeeperEnsemblePlacementPolicyProperties;
    }

    public void setBookKeeperEnsemblePlacementPolicyProperties(Map<String, Object> bookKeeperEnsemblePlacementPolicyProperties) {
        this.bookKeeperEnsemblePlacementPolicyProperties = bookKeeperEnsemblePlacementPolicyProperties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean isDeletionAtBatchIndexLevelEnabled() {
        return this.deletionAtBatchIndexLevelEnabled;
    }

    public void setDeletionAtBatchIndexLevelEnabled(boolean deletionAtBatchIndexLevelEnabled) {
        this.deletionAtBatchIndexLevelEnabled = deletionAtBatchIndexLevelEnabled;
    }

    public int getNewEntriesCheckDelayInMillis() {
        return this.newEntriesCheckDelayInMillis;
    }

    public void setNewEntriesCheckDelayInMillis(int newEntriesCheckDelayInMillis) {
        this.newEntriesCheckDelayInMillis = newEntriesCheckDelayInMillis;
    }

    public ManagedLedgerInterceptor getManagedLedgerInterceptor() {
        return this.managedLedgerInterceptor;
    }

    public void setManagedLedgerInterceptor(ManagedLedgerInterceptor managedLedgerInterceptor) {
        this.managedLedgerInterceptor = managedLedgerInterceptor;
    }

    public int getInactiveLedgerRollOverTimeMs() {
        return this.inactiveLedgerRollOverTimeMs;
    }

    public void setInactiveLedgerRollOverTime(int inactiveLedgerRollOverTimeMs, TimeUnit unit) {
        this.inactiveLedgerRollOverTimeMs = (int)unit.toMillis(inactiveLedgerRollOverTimeMs);
    }

    public int getMinimumBacklogCursorsForCaching() {
        return this.minimumBacklogCursorsForCaching;
    }

    public void setMinimumBacklogCursorsForCaching(int minimumBacklogCursorsForCaching) {
        this.minimumBacklogCursorsForCaching = minimumBacklogCursorsForCaching;
    }

    public int getMinimumBacklogEntriesForCaching() {
        return this.minimumBacklogEntriesForCaching;
    }

    public void setMinimumBacklogEntriesForCaching(int minimumBacklogEntriesForCaching) {
        this.minimumBacklogEntriesForCaching = minimumBacklogEntriesForCaching;
    }

    public int getMaxBacklogBetweenCursorsForCaching() {
        return this.maxBacklogBetweenCursorsForCaching;
    }

    public void setMaxBacklogBetweenCursorsForCaching(int maxBacklogBetweenCursorsForCaching) {
        this.maxBacklogBetweenCursorsForCaching = maxBacklogBetweenCursorsForCaching;
    }

    public boolean isTriggerOffloadOnTopicLoad() {
        return this.triggerOffloadOnTopicLoad;
    }

    public void setTriggerOffloadOnTopicLoad(boolean triggerOffloadOnTopicLoad) {
        this.triggerOffloadOnTopicLoad = triggerOffloadOnTopicLoad;
    }

    public String getShadowSource() {
        return MapUtils.getString(this.properties, (Object)PROPERTY_SOURCE_TOPIC_KEY);
    }

    @Generated
    public boolean isCacheEvictionByMarkDeletedPosition() {
        return this.cacheEvictionByMarkDeletedPosition;
    }

    @Generated
    public void setCacheEvictionByMarkDeletedPosition(boolean cacheEvictionByMarkDeletedPosition) {
        this.cacheEvictionByMarkDeletedPosition = cacheEvictionByMarkDeletedPosition;
    }

    @Generated
    public String getShadowSourceName() {
        return this.shadowSourceName;
    }

    @Generated
    public void setShadowSourceName(String shadowSourceName) {
        this.shadowSourceName = shadowSourceName;
    }
}

