/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.ea.agentloader.AgentLoader;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.aspectj.weaver.loadtime.Agent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class PulsarBrokerStarter {
    private static final Logger log = LoggerFactory.getLogger(PulsarBrokerStarter.class);

    private static ServiceConfiguration loadConfig(String configFile) throws Exception {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        ServiceConfiguration config = (ServiceConfiguration)PulsarConfigurationLoader.create((InputStream)new FileInputStream(configFile), ServiceConfiguration.class);
        PulsarConfigurationLoader.isComplete((Object)config);
        return config;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("Need to specify a configuration file");
        }
        Thread.setDefaultUncaughtExceptionHandler((thread, exception) -> log.error("Uncaught exception in thread {}: {}", new Object[]{thread.getName(), exception.getMessage(), exception}));
        String configFile = args[0];
        ServiceConfiguration config = PulsarBrokerStarter.loadConfig(configFile);
        AgentLoader.loadAgentClass((String)Agent.class.getName(), null);
        PulsarService service = new PulsarService(config);
        Runtime.getRuntime().addShutdownHook(service.getShutdownService());
        try {
            service.start();
            log.info("PulsarService started");
        }
        catch (PulsarServerException e) {
            log.error("Failed to start pulsar service.", (Throwable)e);
            Runtime.getRuntime().halt(1);
        }
        service.waitUntilClosed();
    }
}

