/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.ea.agentloader.AgentLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.PropertyAdmin;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.aspectj.weaver.loadtime.Agent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarStandaloneStarter {
    PulsarService broker;
    PulsarAdmin admin;
    LocalBookkeeperEnsemble bkEnsemble;
    ServiceConfiguration config;
    @Parameter(names={"-c", "--config"}, description="Configuration file path", required=true)
    private String configFile;
    @Parameter(names={"--wipe-data"}, description="Clean up previous ZK/BK data")
    private boolean wipeData = false;
    @Parameter(names={"--num-bookies"}, description="Number of local Bookies")
    private int numOfBk = 1;
    @Parameter(names={"--zookeeper-port"}, description="Local zookeeper's port")
    private int zkPort = 2181;
    @Parameter(names={"--bookkeeper-port"}, description="Local bookies base port")
    private int bkPort = 3181;
    @Parameter(names={"--zookeeper-dir"}, description="Local zooKeeper's data directory")
    private String zkDir = "data/standalone/zookeeper";
    @Parameter(names={"--bookkeeper-dir"}, description="Local bookies base data directory")
    private String bkDir = "data/standalone/bookkeeper";
    @Parameter(names={"--no-broker"}, description="Only start ZK and BK services, no broker")
    private boolean noBroker = false;
    @Parameter(names={"--only-broker"}, description="Only start Pulsar broker service (no ZK, BK)")
    private boolean onlyBroker = false;
    @Parameter(names={"-a", "--advertised-address"}, description="Standalone broker advertised address")
    private String advertisedAddress = null;
    @Parameter(names={"-h", "--help"}, description="Show this help message")
    private boolean help = false;
    private static final Logger log = LoggerFactory.getLogger(PulsarStandaloneStarter.class);

    public PulsarStandaloneStarter(String[] args) throws Exception {
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)this);
            jcommander.parse(args);
            if (this.help || StringUtils.isBlank((CharSequence)this.configFile)) {
                jcommander.usage();
                return;
            }
            if (this.noBroker && this.onlyBroker) {
                log.error("Only one option is allowed between '--no-broker' and '--only-broker'");
                jcommander.usage();
                return;
            }
        }
        catch (Exception exception) {
            jcommander.usage();
            return;
        }
        this.config = (ServiceConfiguration)PulsarConfigurationLoader.create((InputStream)new FileInputStream(this.configFile), ServiceConfiguration.class);
        PulsarConfigurationLoader.isComplete((Object)this.config);
        this.config.setZookeeperServers("127.0.0.1:" + this.zkPort);
        this.config.setGlobalZookeeperServers("127.0.0.1:" + this.zkPort);
        if (this.advertisedAddress != null) {
            this.config.setAdvertisedAddress(this.advertisedAddress);
        } else if (StringUtils.isBlank((CharSequence)this.config.getAdvertisedAddress())) {
            this.config.setAdvertisedAddress(ServiceConfigurationUtils.unsafeLocalhostResolve());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (PulsarStandaloneStarter.this.broker != null) {
                        PulsarStandaloneStarter.this.broker.close();
                    }
                    if (PulsarStandaloneStarter.this.bkEnsemble != null) {
                        PulsarStandaloneStarter.this.bkEnsemble.stop();
                    }
                }
                catch (Exception e) {
                    log.error("Shutdown failed: {}", (Object)e.getMessage());
                }
            }
        });
    }

    void start() throws Exception {
        if (this.config == null) {
            System.exit(1);
        }
        log.debug("--- setup PulsarStandaloneStarter ---");
        if (!this.onlyBroker) {
            this.bkEnsemble = new LocalBookkeeperEnsemble(this.numOfBk, this.zkPort, this.bkPort, this.zkDir, this.bkDir, this.wipeData);
            this.bkEnsemble.start();
        }
        if (this.noBroker) {
            return;
        }
        AgentLoader.loadAgentClass((String)Agent.class.getName(), null);
        this.broker = new PulsarService(this.config);
        this.broker.start();
        URL webServiceUrl = new URL(String.format("http://%s:%d", this.config.getAdvertisedAddress(), this.config.getWebServicePort()));
        String brokerServiceUrl = String.format("pulsar://%s:%d", this.config.getAdvertisedAddress(), this.config.getBrokerServicePort());
        this.admin = new PulsarAdmin(webServiceUrl, this.config.getBrokerClientAuthenticationPlugin(), this.config.getBrokerClientAuthenticationParameters());
        String property = "sample";
        String cluster = this.config.getClusterName();
        String namespace = String.valueOf(property) + "/" + cluster + "/ns1";
        try {
            ClusterData clusterData = new ClusterData(webServiceUrl.toString(), null, brokerServiceUrl, null);
            if (!this.admin.clusters().getClusters().contains(cluster)) {
                this.admin.clusters().createCluster(cluster, clusterData);
            } else {
                this.admin.clusters().updateCluster(cluster, clusterData);
            }
            if (!this.admin.properties().getProperties().contains(property)) {
                this.admin.properties().createProperty(property, new PropertyAdmin((List)Lists.newArrayList((Iterable)this.config.getSuperUserRoles()), (Set)Sets.newHashSet((Object[])new String[]{cluster})));
            }
            if (!this.admin.namespaces().getNamespaces(property).contains(namespace)) {
                this.admin.namespaces().createNamespace(namespace);
            }
        }
        catch (PulsarAdminException e) {
            log.info(e.getMessage());
        }
        log.debug("--- setup completed ---");
    }

    public static void main(String[] args) throws Exception {
        PulsarStandaloneStarter standalone = new PulsarStandaloneStarter(args);
        standalone.start();
    }
}

