/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import com.google.common.collect.Lists;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.BookKeeperClientFactoryImpl;
import org.apache.pulsar.broker.ManagedLedgerClientFactory;
import org.apache.pulsar.broker.MessagingServiceShutdownHook;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.broker.cache.LocalZooKeeperCacheService;
import org.apache.pulsar.broker.loadbalance.LeaderElectionService;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.LoadReportUpdaterTask;
import org.apache.pulsar.broker.loadbalance.LoadResourceQuotaUpdaterTask;
import org.apache.pulsar.broker.loadbalance.LoadSheddingTask;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.stats.MetricsGenerator;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsServlet;
import org.apache.pulsar.broker.web.WebService;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.util.FutureUtil;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.utils.PulsarBrokerVersionStringUtils;
import org.apache.pulsar.websocket.WebSocketConsumerServlet;
import org.apache.pulsar.websocket.WebSocketProducerServlet;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.zookeeper.GlobalZooKeeperCache;
import org.apache.pulsar.zookeeper.LocalZooKeeperCache;
import org.apache.pulsar.zookeeper.LocalZooKeeperConnectionService;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZooKeeperSessionWatcher;
import org.apache.pulsar.zookeeper.ZookeeperBkClientFactoryImpl;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarService
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarService.class);
    private ServiceConfiguration config = null;
    private NamespaceService nsservice = null;
    private ManagedLedgerClientFactory managedLedgerClientFactory = null;
    private LeaderElectionService leaderElectionService = null;
    private BrokerService brokerService = null;
    private WebService webService = null;
    private WebSocketService webSocketService = null;
    private ConfigurationCacheService configurationCacheService = null;
    private LocalZooKeeperCacheService localZkCacheService = null;
    private BookKeeperClientFactory bkClientFactory;
    private ZooKeeperCache localZkCache;
    private GlobalZooKeeperCache globalZkCache;
    private LocalZooKeeperConnectionService localZooKeeperConnectionProvider;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(20, (ThreadFactory)new DefaultThreadFactory("pulsar"));
    private final ScheduledExecutorService cacheExecutor = Executors.newScheduledThreadPool(10, (ThreadFactory)new DefaultThreadFactory("zk-cache-callback"));
    private final OrderedSafeExecutor orderedExecutor = new OrderedSafeExecutor(8, "pulsar-ordered");
    private final ScheduledExecutorService loadManagerExecutor;
    private ScheduledFuture<?> loadReportTask = null;
    private ScheduledFuture<?> loadSheddingTask = null;
    private ScheduledFuture<?> loadResourceQuotaTask = null;
    private final AtomicReference<LoadManager> loadManager = new AtomicReference();
    private PulsarAdmin adminClient = null;
    private ZooKeeperClientFactory zkClientFactory = null;
    private final String bindAddress;
    private final String advertisedAddress;
    private final String webServiceAddress;
    private final String webServiceAddressTls;
    private final String brokerServiceUrl;
    private final String brokerServiceUrlTls;
    private final String brokerVersion;
    private final MessagingServiceShutdownHook shutdownService;
    private MetricsGenerator metricsGenerator;
    private State state;
    private final ReentrantLock mutex = new ReentrantLock();
    private final Condition isClosedCondition = this.mutex.newCondition();

    public PulsarService(ServiceConfiguration config) {
        this.state = State.Init;
        this.bindAddress = ServiceConfigurationUtils.getDefaultOrConfiguredAddress((String)config.getBindAddress());
        this.advertisedAddress = PulsarService.advertisedAddress(config);
        this.webServiceAddress = PulsarService.webAddress(config);
        this.webServiceAddressTls = PulsarService.webAddressTls(config);
        this.brokerServiceUrl = PulsarService.brokerUrl(config);
        this.brokerServiceUrlTls = PulsarService.brokerUrlTls(config);
        this.brokerVersion = PulsarBrokerVersionStringUtils.getNormalizedVersionString();
        this.config = config;
        this.shutdownService = new MessagingServiceShutdownHook(this);
        this.loadManagerExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("pulsar-load-manager"));
    }

    @Override
    public void close() throws PulsarServerException {
        this.mutex.lock();
        try {
            if (this.state == State.Closed) {
                return;
            }
            try {
                if (this.webService != null) {
                    this.webService.close();
                    this.webService = null;
                }
                if (this.brokerService != null) {
                    this.brokerService.close();
                    this.brokerService = null;
                }
                if (this.managedLedgerClientFactory != null) {
                    this.managedLedgerClientFactory.close();
                    this.managedLedgerClientFactory = null;
                }
                if (this.bkClientFactory != null) {
                    this.bkClientFactory.close();
                    this.bkClientFactory = null;
                }
                if (this.leaderElectionService != null) {
                    this.leaderElectionService.stop();
                    this.leaderElectionService = null;
                }
                this.loadManagerExecutor.shutdown();
                if (this.globalZkCache != null) {
                    this.globalZkCache.close();
                    this.globalZkCache = null;
                    this.localZooKeeperConnectionProvider.close();
                    this.localZooKeeperConnectionProvider = null;
                }
                this.configurationCacheService = null;
                this.localZkCacheService = null;
                this.localZkCache = null;
                if (this.adminClient != null) {
                    this.adminClient.close();
                    this.adminClient = null;
                }
                this.nsservice = null;
                if (this.executor != null) {
                    this.executor.shutdown();
                }
                this.orderedExecutor.shutdown();
                this.cacheExecutor.shutdown();
                LoadManager loadManager = this.loadManager.get();
                if (loadManager != null) {
                    loadManager.stop();
                }
                this.state = State.Closed;
            }
            catch (Exception e) {
                throw new PulsarServerException((Throwable)e);
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    public ServiceConfiguration getConfiguration() {
        return this.config;
    }

    public void start() throws PulsarServerException {
        this.mutex.lock();
        try {
            try {
                if (this.state != State.Init) {
                    throw new PulsarServerException("Cannot start the service once it was stopped");
                }
                this.localZooKeeperConnectionProvider = new LocalZooKeeperConnectionService(this.getZooKeeperClientFactory(), this.config.getZookeeperServers(), this.config.getZooKeeperSessionTimeoutMillis());
                this.localZooKeeperConnectionProvider.start((ZooKeeperSessionWatcher.ShutdownService)this.shutdownService);
                this.startZkCacheService();
                this.bkClientFactory = this.getBookKeeperClientFactory();
                this.managedLedgerClientFactory = new ManagedLedgerClientFactory(this.config, this.getZkClient(), this.bkClientFactory);
                this.brokerService = new BrokerService(this);
                this.loadManager.set(LoadManager.create(this));
                this.startLoadManagementService();
                this.startNamespaceService();
                LOG.info("Starting Pulsar Broker service; version: '{}'", (Object)(this.brokerVersion != null ? this.brokerVersion : "unknown"));
                this.brokerService.start();
                this.webService = new WebService(this);
                this.webService.addRestResources("/", "org.apache.pulsar.broker.web", false);
                this.webService.addRestResources("/admin", "org.apache.pulsar.broker.admin", true);
                this.webService.addRestResources("/lookup", "org.apache.pulsar.broker.lookup", true);
                this.webService.addServlet("/metrics", new ServletHolder((Servlet)new PrometheusMetricsServlet(this)), false);
                if (this.config.isWebSocketServiceEnabled()) {
                    this.webSocketService = new WebSocketService(new ClusterData(this.webServiceAddress, this.webServiceAddressTls, this.brokerServiceUrl, this.brokerServiceUrlTls), this.config);
                    this.webSocketService.start();
                    this.webService.addServlet("/ws/producer", new ServletHolder((Servlet)new WebSocketProducerServlet(this.webSocketService)), true);
                    this.webService.addServlet("/ws/consumer", new ServletHolder((Servlet)new WebSocketConsumerServlet(this.webSocketService)), true);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attempting to add static directory");
                }
                this.webService.addStaticResources("/static", "/static");
                this.nsservice.registerBootstrapNamespaces();
                this.leaderElectionService = new LeaderElectionService(this, new LeaderElectionService.LeaderListener(){

                    @Override
                    public synchronized void brokerIsTheLeaderNow() {
                        if (PulsarService.this.getConfiguration().isLoadBalancerEnabled()) {
                            long loadSheddingInterval = TimeUnit.MINUTES.toMillis(PulsarService.this.getConfiguration().getLoadBalancerSheddingIntervalMinutes());
                            long resourceQuotaUpdateInterval = TimeUnit.MINUTES.toMillis(PulsarService.this.getConfiguration().getLoadBalancerResourceQuotaUpdateIntervalMinutes());
                            PulsarService.this.loadSheddingTask = PulsarService.this.loadManagerExecutor.scheduleAtFixedRate(new LoadSheddingTask(PulsarService.this.loadManager), loadSheddingInterval, loadSheddingInterval, TimeUnit.MILLISECONDS);
                            PulsarService.this.loadResourceQuotaTask = PulsarService.this.loadManagerExecutor.scheduleAtFixedRate(new LoadResourceQuotaUpdaterTask(PulsarService.this.loadManager), resourceQuotaUpdateInterval, resourceQuotaUpdateInterval, TimeUnit.MILLISECONDS);
                        }
                    }

                    @Override
                    public synchronized void brokerIsAFollowerNow() {
                        if (PulsarService.this.loadSheddingTask != null) {
                            PulsarService.this.loadSheddingTask.cancel(false);
                            PulsarService.this.loadSheddingTask = null;
                        }
                        if (PulsarService.this.loadResourceQuotaTask != null) {
                            PulsarService.this.loadResourceQuotaTask.cancel(false);
                            PulsarService.this.loadResourceQuotaTask = null;
                        }
                    }
                });
                this.leaderElectionService.start();
                this.webService.start();
                this.metricsGenerator = new MetricsGenerator(this);
                this.state = State.Started;
                this.acquireSLANamespace();
                LOG.info("messaging service is ready, bootstrap service on port={}, broker url={}, cluster={}, configs={}", new Object[]{this.config.getWebServicePort(), this.brokerServiceUrl, this.config.getClusterName(), this.config});
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new PulsarServerException((Throwable)e);
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    private void acquireSLANamespace() {
        try {
            boolean acquiredSLANamespace;
            if (!this.globalZkCache.exists(String.valueOf(AdminResource.path("policies")) + "/" + NamespaceService.getSLAMonitorNamespace(this.getAdvertisedAddress(), this.config))) {
                return;
            }
            try {
                acquiredSLANamespace = this.nsservice.registerSLANamespace();
            }
            catch (PulsarServerException pulsarServerException) {
                acquiredSLANamespace = false;
            }
            if (!acquiredSLANamespace) {
                this.nsservice.unloadSLANamespace();
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception while trying to unload the SLA namespace, will try to unload the namespace again after 1 minute. Exception:", (Throwable)ex);
            this.executor.schedule(this::acquireSLANamespace, 1L, TimeUnit.MINUTES);
        }
        catch (Throwable ex) {
            LOG.warn("Exception while trying to unload the SLA namespace, will not try to unload the namespace again. Exception:", ex);
        }
    }

    public void waitUntilClosed() throws InterruptedException {
        this.mutex.lock();
        try {
            while (this.state != State.Closed) {
                this.isClosedCondition.await();
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    private void startZkCacheService() throws PulsarServerException {
        LOG.info("starting configuration cache service");
        this.localZkCache = new LocalZooKeeperCache(this.getZkClient(), this.getOrderedExecutor(), this.cacheExecutor);
        this.globalZkCache = new GlobalZooKeeperCache(this.getZooKeeperClientFactory(), (int)this.config.getZooKeeperSessionTimeoutMillis(), this.config.getGlobalZookeeperServers(), this.getOrderedExecutor(), this.cacheExecutor);
        try {
            this.globalZkCache.start();
        }
        catch (IOException e) {
            throw new PulsarServerException((Throwable)e);
        }
        this.configurationCacheService = new ConfigurationCacheService(this.getGlobalZkCache());
        this.localZkCacheService = new LocalZooKeeperCacheService(this.getLocalZkCache(), this.configurationCacheService);
    }

    private void startNamespaceService() throws PulsarServerException {
        LOG.info("starting name space service, bootstrap namespaces=" + this.config.getBootstrapNamespaces());
        this.nsservice = this.getNamespaceServiceProvider().get();
    }

    public Supplier<NamespaceService> getNamespaceServiceProvider() throws PulsarServerException {
        return () -> new NamespaceService(this);
    }

    private void startLoadManagementService() throws PulsarServerException {
        LOG.info("Starting load management service ...");
        this.loadManager.get().start();
        if (this.config.isLoadBalancerEnabled()) {
            LOG.info("Starting load balancer");
            if (this.loadReportTask == null) {
                long loadReportMinInterval = SimpleLoadManagerImpl.LOAD_REPORT_UPDATE_MIMIMUM_INTERVAL;
                this.loadReportTask = this.loadManagerExecutor.scheduleAtFixedRate(new LoadReportUpdaterTask(this.loadManager), loadReportMinInterval, loadReportMinInterval, TimeUnit.MILLISECONDS);
            }
        }
    }

    public void loadNamespaceDestinations(NamespaceBundle bundle) {
        this.executor.submit(() -> {
            LOG.info("Loading all topics on bundle: {}", (Object)bundle);
            NamespaceName nsName = bundle.getNamespaceObject();
            ArrayList persistentTopics = Lists.newArrayList();
            long topicLoadStart = System.nanoTime();
            for (String topic : this.getNamespaceService().getListOfDestinations(nsName.getProperty(), nsName.getCluster(), nsName.getLocalName())) {
                try {
                    CompletableFuture<Topic> future;
                    DestinationName dn = DestinationName.get((String)topic);
                    if (!bundle.includes(dn) || (future = this.brokerService.getTopic(topic)) == null) continue;
                    persistentTopics.add(future);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to preload topic {}", (Object)topic, (Object)t);
                }
            }
            if (!persistentTopics.isEmpty()) {
                FutureUtil.waitForAll((List)persistentTopics).thenRun(() -> {
                    double topicLoadTimeSeconds = (double)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - topicLoadStart) / 1000.0;
                    LOG.info("Loaded {} topics on {} -- time taken: {} seconds", new Object[]{persistentTopics.size(), bundle, topicLoadTimeSeconds});
                });
            }
            return null;
        });
    }

    public String getStatusFilePath() {
        if (this.config == null) {
            return null;
        }
        return this.config.getStatusFilePath();
    }

    public ZooKeeper getZkClient() {
        return this.localZooKeeperConnectionProvider.getLocalZooKeeper();
    }

    public ConfigurationCacheService getConfigurationCache() {
        return this.configurationCacheService;
    }

    public State getState() {
        return this.state;
    }

    public LeaderElectionService getLeaderElectionService() {
        return this.leaderElectionService;
    }

    public NamespaceService getNamespaceService() {
        return this.nsservice;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public ManagedLedgerFactory getManagedLedgerFactory() {
        return this.managedLedgerClientFactory.getManagedLedgerFactory();
    }

    public ZooKeeperCache getLocalZkCache() {
        return this.localZkCache;
    }

    public ZooKeeperCache getGlobalZkCache() {
        return this.globalZkCache;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getCacheExecutor() {
        return this.cacheExecutor;
    }

    public ScheduledExecutorService getLoadManagerExecutor() {
        return this.loadManagerExecutor;
    }

    public OrderedSafeExecutor getOrderedExecutor() {
        return this.orderedExecutor;
    }

    public LocalZooKeeperCacheService getLocalZkCacheService() {
        return this.localZkCacheService;
    }

    public ZooKeeperClientFactory getZooKeeperClientFactory() {
        if (this.zkClientFactory == null) {
            this.zkClientFactory = new ZookeeperBkClientFactoryImpl();
        }
        return this.zkClientFactory;
    }

    public BookKeeperClientFactory getBookKeeperClientFactory() {
        return new BookKeeperClientFactoryImpl();
    }

    public synchronized PulsarAdmin getAdminClient() throws PulsarServerException {
        if (this.adminClient == null) {
            try {
                String adminApiUrl = PulsarService.webAddress(this.config);
                this.adminClient = new PulsarAdmin(new URL(adminApiUrl), this.getConfiguration().getBrokerClientAuthenticationPlugin(), this.getConfiguration().getBrokerClientAuthenticationParameters());
                LOG.info("Admin api url: " + adminApiUrl);
            }
            catch (Exception e) {
                throw new PulsarServerException((Throwable)e);
            }
        }
        return this.adminClient;
    }

    public MetricsGenerator getMetricsGenerator() {
        return this.metricsGenerator;
    }

    public MessagingServiceShutdownHook getShutdownService() {
        return this.shutdownService;
    }

    public static String advertisedAddress(ServiceConfiguration config) {
        return ServiceConfigurationUtils.getDefaultOrConfiguredAddress((String)config.getAdvertisedAddress());
    }

    public static String brokerUrl(ServiceConfiguration config) {
        return "pulsar://" + PulsarService.advertisedAddress(config) + ":" + config.getBrokerServicePort();
    }

    public static String brokerUrlTls(ServiceConfiguration config) {
        if (config.isTlsEnabled()) {
            return "pulsar://" + PulsarService.advertisedAddress(config) + ":" + config.getBrokerServicePortTls();
        }
        return "";
    }

    public static String webAddress(ServiceConfiguration config) {
        return String.format("http://%s:%d", PulsarService.advertisedAddress(config), config.getWebServicePort());
    }

    public static String webAddressTls(ServiceConfiguration config) {
        if (config.isTlsEnabled()) {
            return String.format("https://%s:%d", PulsarService.advertisedAddress(config), config.getWebServicePortTls());
        }
        return "";
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public String getAdvertisedAddress() {
        return this.advertisedAddress;
    }

    public String getWebServiceAddress() {
        return this.webServiceAddress;
    }

    public String getWebServiceAddressTls() {
        return this.webServiceAddressTls;
    }

    public String getBrokerServiceUrl() {
        return this.brokerServiceUrl;
    }

    public String getBrokerServiceUrlTls() {
        return this.brokerServiceUrlTls;
    }

    public AtomicReference<LoadManager> getLoadManager() {
        return this.loadManager;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public static enum State {
        Init,
        Started,
        Closed;

    }
}

