/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/clusters")
@Api(value="/clusters", description="Cluster admin apis", tags={"clusters"})
@Produces(value={"application/json"})
public class Clusters
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(Clusters.class);

    @GET
    @ApiOperation(value="Get the list of all the Pulsar clusters.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public Set<String> getClusters() throws Exception {
        try {
            return this.clustersListCache().get();
        }
        catch (Exception e) {
            log.error("[{}] Failed to get clusters list", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/{cluster}")
    @ApiOperation(value="Get the configuration data for the specified cluster.", response=ClusterData.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Cluster doesn't exist")})
    public ClusterData getCluster(@PathParam(value="cluster") String cluster) {
        this.validateSuperUserAccess();
        try {
            return (ClusterData)this.clustersCache().get(Clusters.path("clusters", cluster)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluster does not exist"));
        }
        catch (Exception e) {
            log.error("[{}] Failed to get cluster {}", new Object[]{this.clientAppId(), cluster, e});
            if (e instanceof RestException) {
                throw (RestException)((Object)e);
            }
            throw new RestException(e);
        }
    }

    @PUT
    @Path(value="/{cluster}")
    @ApiOperation(value="Provisions a new cluster. This operation requires Pulsar super-user privileges.", notes="The name cannot contain '/' characters.")
    @ApiResponses(value={@ApiResponse(code=204, message="Cluster has been created"), @ApiResponse(code=403, message="You don't have admin permission to create the cluster"), @ApiResponse(code=409, message="Cluster already exists"), @ApiResponse(code=412, message="Cluster name is not valid")})
    public void createCluster(@PathParam(value="cluster") String cluster, ClusterData clusterData) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            NamedEntity.checkName((String)cluster);
            this.zkCreate(Clusters.path("clusters", cluster), Clusters.jsonMapper().writeValueAsBytes((Object)clusterData));
            log.info("[{}] Created cluster {}", (Object)this.clientAppId(), (Object)cluster);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            log.warn("[{}] Failed to create already existing cluster {}", (Object)this.clientAppId(), (Object)cluster);
            throw new RestException(Response.Status.CONFLICT, "Cluster already exist");
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to create cluster with invalid name {}", new Object[]{this.clientAppId(), cluster, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Cluster name is not valid");
        }
        catch (Exception e) {
            log.error("[{}] Failed to create cluster {}", new Object[]{this.clientAppId(), cluster, e});
            throw new RestException(e);
        }
    }

    @POST
    @Path(value="/{cluster}")
    @ApiOperation(value="Update the configuration for a cluster.", notes="This operation requires Pulsar super-user privileges.")
    @ApiResponses(value={@ApiResponse(code=204, message="Cluster has been updated"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Cluster doesn't exist")})
    public void updateCluster(@PathParam(value="cluster") String cluster, ClusterData clusterData) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            String clusterPath = Clusters.path("clusters", cluster);
            this.globalZk().setData(clusterPath, Clusters.jsonMapper().writeValueAsBytes((Object)clusterData), -1);
            this.globalZkCache().invalidate(clusterPath);
            log.info("[{}] Updated cluster {}", (Object)this.clientAppId(), (Object)cluster);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            log.warn("[{}] Failed to update cluster {}: Does not exist", (Object)this.clientAppId(), (Object)cluster);
            throw new RestException(Response.Status.NOT_FOUND, "Cluster does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update cluster {}", new Object[]{this.clientAppId(), cluster, e});
            throw new RestException(e);
        }
    }

    @DELETE
    @Path(value="/{cluster}")
    @ApiOperation(value="Delete an existing cluster")
    @ApiResponses(value={@ApiResponse(code=204, message="Cluster has been updated"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Cluster doesn't exist"), @ApiResponse(code=412, message="Cluster is not empty")})
    public void deleteCluster(@PathParam(value="cluster") String cluster) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        boolean isClusterUsed = false;
        try {
            for (String property : this.globalZk().getChildren(Clusters.path("policies"), false)) {
                if (this.globalZk().exists(Clusters.path("policies", property, cluster), false) == null) continue;
                if (this.globalZk().getChildren(Clusters.path("policies", property, cluster), false).isEmpty()) continue;
                isClusterUsed = true;
                break;
            }
            String path = Clusters.path("clusters", cluster, "namespaceIsolationPolicies");
            Optional nsIsolationPolicies = this.namespaceIsolationPoliciesCache().get(path);
            if (nsIsolationPolicies.isPresent()) {
                if (((NamespaceIsolationPolicies)nsIsolationPolicies.get()).getPolicies().isEmpty()) {
                    this.globalZk().delete(path, -1);
                    this.namespaceIsolationPoliciesCache().invalidate(path);
                } else {
                    isClusterUsed = true;
                }
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to get cluster usage {}", new Object[]{this.clientAppId(), cluster, e});
            throw new RestException(e);
        }
        if (isClusterUsed) {
            log.warn("[{}] Failed to delete cluster {} - Cluster not empty", (Object)this.clientAppId(), (Object)cluster);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Cluster not empty");
        }
        try {
            String clusterPath = Clusters.path("clusters", cluster);
            this.globalZk().delete(clusterPath, -1);
            this.globalZkCache().invalidate(clusterPath);
            log.info("[{}] Deleted cluster {}", (Object)this.clientAppId(), (Object)cluster);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            log.warn("[{}] Failed to delete cluster {} - Does not exist", (Object)this.clientAppId(), (Object)cluster);
            throw new RestException(Response.Status.NOT_FOUND, "Cluster does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete cluster {}", new Object[]{this.clientAppId(), cluster, e});
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/{cluster}/namespaceIsolationPolicies")
    @ApiOperation(value="Get the namespace isolation policies assigned in the cluster", response=NamespaceIsolationData.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Cluster doesn't exist")})
    public Map<String, NamespaceIsolationData> getNamespaceIsolationPolicies(@PathParam(value="cluster") String cluster) throws Exception {
        this.validateSuperUserAccess();
        if (!this.clustersCache().get(Clusters.path("clusters", cluster)).isPresent()) {
            throw new RestException(Response.Status.NOT_FOUND, "Cluster " + cluster + " does not exist.");
        }
        try {
            NamespaceIsolationPolicies nsIsolationPolicies = (NamespaceIsolationPolicies)this.namespaceIsolationPoliciesCache().get(Clusters.path("clusters", cluster, "namespaceIsolationPolicies")).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "NamespaceIsolationPolicies for cluster " + cluster + " does not exist"));
            return nsIsolationPolicies.getPolicies();
        }
        catch (Exception e) {
            log.error("[{}] Failed to get clusters/{}/namespaceIsolationPolicies", new Object[]{this.clientAppId(), cluster, e});
            throw new RestException(e);
        }
    }

    private void validateClusterExists(String cluster) {
        try {
            if (!this.clustersCache().get(Clusters.path("clusters", cluster)).isPresent()) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cluster " + cluster + " does not exist.");
            }
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/{cluster}/namespaceIsolationPolicies/{policyName}")
    @ApiOperation(value="Get a single namespace isolation policy assigned in the cluster", response=NamespaceIsolationData.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Policy doesn't exist"), @ApiResponse(code=412, message="Cluster doesn't exist")})
    public NamespaceIsolationData getNamespaceIsolationPolicy(@PathParam(value="cluster") String cluster, @PathParam(value="policyName") String policyName) throws Exception {
        this.validateSuperUserAccess();
        this.validateClusterExists(cluster);
        try {
            NamespaceIsolationPolicies nsIsolationPolicies = (NamespaceIsolationPolicies)this.namespaceIsolationPoliciesCache().get(Clusters.path("clusters", cluster, "namespaceIsolationPolicies")).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "NamespaceIsolationPolicies for cluster " + cluster + " does not exist"));
            if (!nsIsolationPolicies.getPolicies().containsKey(policyName)) {
                log.info("[{}] Cannot find NamespaceIsolationPolicy {} for cluster {}", (Object)policyName, (Object)cluster);
                throw new RestException(Response.Status.NOT_FOUND, "Cannot find NamespaceIsolationPolicy " + policyName + " for cluster " + cluster);
            }
            return (NamespaceIsolationData)nsIsolationPolicies.getPolicies().get(policyName);
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get clusters/{}/namespaceIsolationPolicies/{}", new Object[]{this.clientAppId(), cluster, e});
            throw new RestException(e);
        }
    }

    @POST
    @Path(value="/{cluster}/namespaceIsolationPolicies/{policyName}")
    @ApiOperation(value="Set namespace isolation policy")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission or plicy is read only"), @ApiResponse(code=412, message="Cluster doesn't exist")})
    public void setNamespaceIsolationPolicy(@PathParam(value="cluster") String cluster, @PathParam(value="policyName") String policyName, NamespaceIsolationData policyData) throws Exception {
        this.validateSuperUserAccess();
        this.validateClusterExists(cluster);
        this.validatePoliciesReadOnlyAccess();
        try {
            policyData.validate();
            String nsIsolationPolicyPath = Clusters.path("clusters", cluster, "namespaceIsolationPolicies");
            NamespaceIsolationPolicies nsIsolationPolicies = this.namespaceIsolationPoliciesCache().get(nsIsolationPolicyPath).orElseGet(() -> {
                try {
                    this.createNamespaceIsolationPolicyNode(nsIsolationPolicyPath);
                    return new NamespaceIsolationPolicies();
                }
                catch (InterruptedException | KeeperException e) {
                    throw new RestException(e);
                }
            });
            nsIsolationPolicies.setPolicy(policyName, policyData);
            this.globalZk().setData(nsIsolationPolicyPath, Clusters.jsonMapper().writeValueAsBytes((Object)nsIsolationPolicies.getPolicies()), -1);
            this.namespaceIsolationPoliciesCache().invalidate(nsIsolationPolicyPath);
        }
        catch (IllegalArgumentException iae) {
            log.info("[{}] Failed to update clusters/{}/namespaceIsolationPolicies/{}. Input data is invalid", new Object[]{this.clientAppId(), cluster, policyName, iae});
            String jsonInput = ObjectMapperFactory.create().writeValueAsString((Object)policyData);
            throw new RestException(Response.Status.BAD_REQUEST, "Invalid format of input policy data. policy: " + policyName + "; data: " + jsonInput);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            log.warn("[{}] Failed to update clusters/{}/namespaceIsolationPolicies: Does not exist", (Object)this.clientAppId(), (Object)cluster);
            throw new RestException(Response.Status.NOT_FOUND, "NamespaceIsolationPolicies for cluster " + cluster + " does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update clusters/{}/namespaceIsolationPolicies/{}", new Object[]{this.clientAppId(), cluster, policyName, e});
            throw new RestException(e);
        }
    }

    private void createNamespaceIsolationPolicyNode(String nsIsolationPolicyPath) throws KeeperException, InterruptedException {
        if (this.globalZk().exists(nsIsolationPolicyPath, false) == null) {
            try {
                ZkUtils.createFullPathOptimistic((ZooKeeper)this.globalZk(), (String)nsIsolationPolicyPath, (byte[])Clusters.jsonMapper().writeValueAsBytes(Collections.emptyMap()), ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                log.debug("Other broker preempted the full path [{}] already. Continue...", (Object)nsIsolationPolicyPath);
            }
            catch (JsonGenerationException jsonGenerationException) {
            }
            catch (JsonMappingException jsonMappingException) {
            }
            catch (IOException iOException) {}
        }
    }

    @DELETE
    @Path(value="/{cluster}/namespaceIsolationPolicies/{policyName}")
    @ApiOperation(value="Delete namespace isolation policy")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission or plicy is read only"), @ApiResponse(code=412, message="Cluster doesn't exist")})
    public void deleteNamespaceIsolationPolicy(@PathParam(value="cluster") String cluster, @PathParam(value="policyName") String policyName) throws Exception {
        this.validateSuperUserAccess();
        this.validateClusterExists(cluster);
        this.validatePoliciesReadOnlyAccess();
        try {
            String nsIsolationPolicyPath = Clusters.path("clusters", cluster, "namespaceIsolationPolicies");
            NamespaceIsolationPolicies nsIsolationPolicies = this.namespaceIsolationPoliciesCache().get(nsIsolationPolicyPath).orElseGet(() -> {
                try {
                    this.createNamespaceIsolationPolicyNode(nsIsolationPolicyPath);
                    return new NamespaceIsolationPolicies();
                }
                catch (InterruptedException | KeeperException e) {
                    throw new RestException(e);
                }
            });
            nsIsolationPolicies.deletePolicy(policyName);
            this.globalZk().setData(nsIsolationPolicyPath, Clusters.jsonMapper().writeValueAsBytes((Object)nsIsolationPolicies.getPolicies()), -1);
            this.namespaceIsolationPoliciesCache().invalidate(nsIsolationPolicyPath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            log.warn("[{}] Failed to update brokers/{}/namespaceIsolationPolicies: Does not exist", (Object)this.clientAppId(), (Object)cluster);
            throw new RestException(Response.Status.NOT_FOUND, "NamespaceIsolationPolicies for cluster " + cluster + " does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update brokers/{}/namespaceIsolationPolicies/{}", new Object[]{this.clientAppId(), cluster, policyName, e});
            throw new RestException(e);
        }
    }
}

