/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/resource-quotas")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/resource-quotas", description="Quota admin APIs", tags={"resource-quotas"})
public class ResourceQuotas
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(ResourceQuotas.class);

    @GET
    @ApiOperation(value="Get the default quota", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public ResourceQuota getDefaultResourceQuota() throws Exception {
        this.validateSuperUserAccess();
        try {
            return this.pulsar().getLocalZkCacheService().getResourceQuotaCache().getDefaultQuota();
        }
        catch (Exception e) {
            log.error("[{}] Failed to get default resource quota", (Object)this.clientAppId());
            throw new RestException(e);
        }
    }

    @POST
    @ApiOperation(value="Set the default quota", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setDefaultResourceQuota(ResourceQuota quota) throws Exception {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            this.pulsar().getLocalZkCacheService().getResourceQuotaCache().setDefaultQuota(quota);
        }
        catch (Exception e) {
            log.error("[{}] Failed to get default resource quota", (Object)this.clientAppId());
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}")
    @ApiOperation(value="Get resource quota of a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public ResourceQuota getNamespaceBundleResourceQuota(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange) {
        this.validateSuperUserAccess();
        Policies policies = this.getNamespacePolicies(property, cluster, namespace);
        if (!cluster.equals("global")) {
            this.validateClusterOwnership(cluster);
            this.validateClusterForProperty(property, cluster);
        }
        NamespaceName fqnn = new NamespaceName(property, cluster, namespace);
        NamespaceBundle nsBundle = this.validateNamespaceBundleRange(fqnn, policies.bundles, bundleRange);
        try {
            return this.pulsar().getLocalZkCacheService().getResourceQuotaCache().getQuota(nsBundle);
        }
        catch (Exception e) {
            log.error("[{}] Failed to get resource quota for namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
            throw new RestException(e);
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}")
    @ApiOperation(value="Set resource quota on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setNamespaceBundleResourceQuota(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, ResourceQuota quota) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        Policies policies = this.getNamespacePolicies(property, cluster, namespace);
        if (!cluster.equals("global")) {
            this.validateClusterOwnership(cluster);
            this.validateClusterForProperty(property, cluster);
        }
        NamespaceName fqnn = new NamespaceName(property, cluster, namespace);
        NamespaceBundle nsBundle = this.validateNamespaceBundleRange(fqnn, policies.bundles, bundleRange);
        try {
            this.pulsar().getLocalZkCacheService().getResourceQuotaCache().setQuota(nsBundle, quota);
            log.info("[{}] Successfully set resource quota for namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
        }
        catch (KeeperException.NoNodeException noNodeException) {
            log.warn("[{}] Failed to set resource quota for namespace bundle {}: concurrent modification", (Object)this.clientAppId(), (Object)nsBundle.toString());
            throw new RestException(Response.Status.CONFLICT, "Cuncurrent modification on namespace bundle quota");
        }
        catch (Exception e) {
            log.error("[{}] Failed to set resource quota for namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
            throw new RestException(e);
        }
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}")
    @ApiOperation(value="Remove resource quota for a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeNamespaceBundleResourceQuota(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        Policies policies = this.getNamespacePolicies(property, cluster, namespace);
        if (!cluster.equals("global")) {
            this.validateClusterOwnership(cluster);
            this.validateClusterForProperty(property, cluster);
        }
        NamespaceName fqnn = new NamespaceName(property, cluster, namespace);
        NamespaceBundle nsBundle = this.validateNamespaceBundleRange(fqnn, policies.bundles, bundleRange);
        try {
            this.pulsar().getLocalZkCacheService().getResourceQuotaCache().unsetQuota(nsBundle);
            log.info("[{}] Successfully unset resource quota for namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
        }
        catch (KeeperException.NoNodeException noNodeException) {
            log.warn("[{}] Failed to unset resource quota for namespace bundle {}: concurrent modification", (Object)this.clientAppId(), (Object)nsBundle.toString());
            throw new RestException(Response.Status.CONFLICT, "Cuncurrent modification on namespace bundle quota");
        }
        catch (Exception e) {
            log.error("[{}] Failed to unset resource quota for namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
            throw new RestException(e);
        }
    }
}

