/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pulsar.broker.BrokerData;
import org.apache.pulsar.broker.BundleData;
import org.apache.pulsar.broker.LocalBrokerData;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.TimeAverageBrokerData;
import org.apache.pulsar.broker.TimeAverageMessageData;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.broker.loadbalance.ModularLoadManagerStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeastLongTermMessageRate
implements ModularLoadManagerStrategy {
    private static Logger log = LoggerFactory.getLogger(LeastLongTermMessageRate.class);
    private ArrayList<String> bestBrokers = new ArrayList();

    public LeastLongTermMessageRate(ServiceConfiguration conf) {
    }

    private static double getScore(BrokerData brokerData, ServiceConfiguration conf) {
        double overloadThreshold = (double)conf.getLoadBalancerBrokerOverloadedThresholdPercentage() / 100.0;
        double totalMessageRate = 0.0;
        for (BundleData bundleData : brokerData.getPreallocatedBundleData().values()) {
            TimeAverageMessageData longTermData = bundleData.getLongTermData();
            totalMessageRate += longTermData.getMsgRateIn() + longTermData.getMsgRateOut();
        }
        TimeAverageBrokerData timeAverageData = brokerData.getTimeAverageData();
        double maxUsage = brokerData.getLocalData().getMaxResourceUsage();
        if (maxUsage > overloadThreshold) {
            log.warn("Broker {} is overloaded: max usage={}", (Object)brokerData.getLocalData().getWebServiceUrl(), (Object)maxUsage);
            return Double.POSITIVE_INFINITY;
        }
        double timeAverageLongTermMessageRate = timeAverageData.getLongTermMsgRateIn() + timeAverageData.getLongTermMsgRateOut();
        double totalMessageRateEstimate = totalMessageRate + timeAverageLongTermMessageRate;
        if (log.isDebugEnabled()) {
            log.debug("Broker {} has long term message rate {}", (Object)brokerData.getLocalData().getWebServiceUrl(), (Object)totalMessageRateEstimate);
        }
        return totalMessageRateEstimate;
    }

    @Override
    public String selectBroker(Set<String> candidates, BundleData bundleToAssign, LoadData loadData, ServiceConfiguration conf) {
        this.bestBrokers.clear();
        double minScore = Double.POSITIVE_INFINITY;
        for (String broker : candidates) {
            BrokerData brokerData = loadData.getBrokerData().get(broker);
            double score = LeastLongTermMessageRate.getScore(brokerData, conf);
            if (score == Double.POSITIVE_INFINITY) {
                LocalBrokerData localData = brokerData.getLocalData();
                log.warn("Broker {} is overloaded: CPU: {}%, MEMORY: {}%, DIRECT MEMORY: {}%, BANDWIDTH IN: {}%, BANDWIDTH OUT: {}%", new Object[]{broker, Float.valueOf(localData.getCpu().percentUsage()), Float.valueOf(localData.getMemory().percentUsage()), Float.valueOf(localData.getDirectMemory().percentUsage()), Float.valueOf(localData.getBandwidthIn().percentUsage()), Float.valueOf(localData.getBandwidthOut().percentUsage())});
            }
            if (score < minScore) {
                this.bestBrokers.clear();
                this.bestBrokers.add(broker);
                minScore = score;
                continue;
            }
            if (score != minScore) continue;
            this.bestBrokers.add(broker);
        }
        if (this.bestBrokers.isEmpty()) {
            this.bestBrokers.addAll(candidates);
        }
        return this.bestBrokers.get(ThreadLocalRandom.current().nextInt(this.bestBrokers.size()));
    }
}

