/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import org.apache.pulsar.broker.loadbalance.ResourceDescription;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;

public class SimpleResourceUnit
implements ResourceUnit {
    private String resourceId;
    private ResourceDescription resourceDescription;

    public SimpleResourceUnit(String resourceId, ResourceDescription resourceDescription) {
        this.resourceId = resourceId;
        this.resourceDescription = resourceDescription;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public ResourceDescription getAvailableResource() {
        return null;
    }

    @Override
    public boolean canFit(ResourceDescription resourceDescription) {
        return this.resourceDescription.compareTo(resourceDescription) > 0;
    }

    @Override
    public int compareTo(ResourceUnit o) {
        return this.resourceId.compareTo(o.getResourceId());
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleResourceUnit)) {
            return false;
        }
        SimpleResourceUnit other = (SimpleResourceUnit)o;
        return this.resourceId.equals(other.resourceId);
    }

    public int hashCode() {
        return this.resourceId.hashCode();
    }
}

