/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.zookeeper.Deserializers;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiVersionFilter
implements Filter {
    private static final String CLIENT_VERSION_PARAM = "pulsar-client-version";
    private static final String MIN_API_VERSION_PATH = "/minApiVersion";
    private static final Logger LOG = LoggerFactory.getLogger(ApiVersionFilter.class);
    private final PulsarService pulsar;
    private final boolean allowUnversionedClients;

    public ApiVersionFilter(PulsarService pulsar, boolean allowUnversionedClients) {
        this.pulsar = pulsar;
        this.allowUnversionedClients = allowUnversionedClients;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        try {
            String minApiVersion = (String)this.pulsar.getLocalZkCache().getData(MIN_API_VERSION_PATH, Deserializers.STRING_DESERIALIZER).orElseThrow(() -> new KeeperException.NoNodeException());
            String requestApiVersion = this.getRequestApiVersion(req);
            if (this.shouldAllowRequest(req.getRemoteAddr(), minApiVersion, requestApiVersion)) {
                chain.doFilter(req, resp);
            } else {
                HttpServletResponse httpResponse = (HttpServletResponse)resp;
                HttpServletResponseWrapper respWrapper = new HttpServletResponseWrapper(httpResponse);
                respWrapper.sendError(400, "Unsuported Client version");
            }
        }
        catch (Exception exception) {
            LOG.warn("[{}] Unable to safely determine client version eligibility. Allowing request", (Object)req.getRemoteAddr());
            chain.doFilter(req, resp);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }

    private boolean shouldAllowRequest(String clientAddress, String minApiVersion, String requestApiVersion) {
        if (requestApiVersion == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[{}] Checking client version: req: {} -- min: {} -- Allow unversioned: {}", new Object[]{clientAddress, requestApiVersion, minApiVersion, this.allowUnversionedClients});
            }
            return this.allowUnversionedClients;
        }
        try {
            float minVersion = Float.parseFloat(minApiVersion);
            float requestVersion = Float.parseFloat(requestApiVersion);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[{}] Checking client version: req: {} -- min: {}", new Object[]{clientAddress, requestApiVersion, minApiVersion});
            }
            return minVersion <= requestVersion;
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn("[{}] Unable to convert version info to floats. minVersion = {}, requestVersion = {}", new Object[]{clientAddress, minApiVersion, requestApiVersion});
            throw new IllegalArgumentException("Invalid Number in min or request API version");
        }
    }

    private String getRequestApiVersion(ServletRequest req) {
        HttpServletRequest httpReq = (HttpServletRequest)req;
        return httpReq.getHeader(CLIENT_VERSION_PARAM);
    }
}

