/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.apache.pulsar.common.naming.DestinationDomain;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceName;

public class NamespaceBundles {
    private final NamespaceName nsname;
    private final ArrayList<NamespaceBundle> bundles;
    private final NamespaceBundleFactory factory;
    protected final long[] partitions;
    public static final Long FULL_LOWER_BOUND = 0L;
    public static final Long FULL_UPPER_BOUND = 0xFFFFFFFFL;
    private final NamespaceBundle fullBundle;

    public NamespaceBundles(NamespaceName nsname, SortedSet<Long> partitionsSet, NamespaceBundleFactory factory) throws Exception {
        this(nsname, NamespaceBundles.convertPartitions(partitionsSet), factory);
    }

    public NamespaceBundles(NamespaceName nsname, long[] partitions, NamespaceBundleFactory factory) {
        this.nsname = (NamespaceName)Preconditions.checkNotNull((Object)nsname);
        this.factory = (NamespaceBundleFactory)Preconditions.checkNotNull((Object)factory);
        Preconditions.checkArgument((partitions.length > 0 ? 1 : 0) != 0, (Object)"Can't create bundles w/o partition boundaries");
        this.bundles = Lists.newArrayList();
        this.fullBundle = new NamespaceBundle(nsname, (Range<Long>)Range.range((Comparable)FULL_LOWER_BOUND, (BoundType)BoundType.CLOSED, (Comparable)FULL_UPPER_BOUND, (BoundType)BoundType.CLOSED), factory);
        if (partitions.length > 0) {
            if (partitions.length == 1) {
                throw new IllegalArgumentException("Need to specify at least 2 boundaries");
            }
            this.partitions = partitions;
            long lowerBound = partitions[0];
            int i = 1;
            while (i < partitions.length) {
                long upperBound = partitions[i];
                Preconditions.checkArgument((upperBound >= lowerBound ? 1 : 0) != 0);
                Range newRange = null;
                newRange = i != partitions.length - 1 ? Range.range((Comparable)Long.valueOf(lowerBound), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(upperBound), (BoundType)BoundType.OPEN) : Range.range((Comparable)Long.valueOf(lowerBound), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(upperBound), (BoundType)BoundType.CLOSED);
                this.bundles.add(new NamespaceBundle(nsname, (Range<Long>)newRange, factory));
                lowerBound = upperBound;
                ++i;
            }
        } else {
            this.partitions = new long[1];
            this.bundles.add(this.fullBundle);
        }
    }

    public NamespaceBundle findBundle(DestinationName dn) {
        Preconditions.checkArgument((boolean)this.nsname.equals((Object)dn.getNamespaceObject()));
        long hashCode = this.factory.getLongHashCode(dn.toString());
        NamespaceBundle bundle = this.getBundle(hashCode);
        if (dn.getDomain().equals((Object)DestinationDomain.non_persistent)) {
            bundle.setHasNonPersistentTopic(true);
        }
        return bundle;
    }

    public List<NamespaceBundle> getBundles() {
        return this.bundles;
    }

    public int size() {
        return this.bundles.size();
    }

    public void validateBundle(NamespaceBundle nsBundle) throws Exception {
        int idx = Arrays.binarySearch(this.partitions, nsBundle.getLowerEndpoint());
        Preconditions.checkArgument((idx >= 0 ? 1 : 0) != 0, (Object)"Cannot find bundle in the bundles list");
        Preconditions.checkArgument((boolean)nsBundle.getUpperEndpoint().equals(this.bundles.get(idx).getUpperEndpoint()), (Object)"Invalid upper boundary for bundle");
    }

    public NamespaceBundle getFullBundle() {
        return this.fullBundle;
    }

    protected NamespaceBundle getBundle(long hash) {
        int idx = Arrays.binarySearch(this.partitions, hash);
        int lowerIdx = idx < 0 ? -(idx + 2) : idx;
        return this.bundles.get(lowerIdx);
    }

    private static final long[] convertPartitions(SortedSet<Long> partitionsSet) {
        Preconditions.checkNotNull(partitionsSet);
        long[] partitions = new long[partitionsSet.size()];
        int idx = 0;
        Iterator iterator = partitionsSet.iterator();
        while (iterator.hasNext()) {
            long p = (Long)iterator.next();
            partitions[idx++] = p;
        }
        return partitions;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof NamespaceBundles) {
            NamespaceBundles other = (NamespaceBundles)obj;
            return Objects.equal((Object)this.nsname, (Object)other.nsname) && Objects.equal(this.bundles, other.bundles);
        }
        return false;
    }
}

