/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import io.netty.buffer.ByteBuf;

public class NumberFormat {
    static void format(ByteBuf out, long num) {
        boolean encounteredMinValue;
        if (num == 0L) {
            out.writeByte(48);
            return;
        }
        boolean bl = encounteredMinValue = num == Long.MIN_VALUE;
        if (num < 0L) {
            out.writeByte(45);
            num += (long)(encounteredMinValue ? 1 : 0);
            num *= -1L;
        }
        int start = out.writerIndex();
        NumberFormat.formatHelper(out, num);
        int end = out.writerIndex();
        if (encounteredMinValue) {
            out.setByte(start, out.getByte(start) + 1);
        }
        --end;
        int i = 0;
        while (i <= (end - start) / 2) {
            byte tmp = out.getByte(end - i);
            out.setByte(end - i, (int)out.getByte(start + i));
            out.setByte(start + i, (int)tmp);
            ++i;
        }
    }

    static void formatHelper(ByteBuf out, long num) {
        while (num != 0L) {
            out.writeByte((int)(48L + num % 10L));
            num /= 10L;
        }
    }
}

