/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.base.Preconditions;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.PersistentTopics;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.NonPersistentTopicStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.util.Codec;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/non-persistent")
@Produces(value={"application/json"})
@Api(value="/non-persistent", description="Non-Persistent topic admin apis", tags={"non-persistent topic"})
public class NonPersistentTopics
extends PersistentTopics {
    private static final Logger log = LoggerFactory.getLogger(NonPersistentTopics.class);

    @Override
    @GET
    @Path(value="/{property}/{cluster}/{namespace}/{destination}/partitions")
    @ApiOperation(value="Get partitioned topic metadata.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public PartitionedTopicMetadata getPartitionedMetadata(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="destination") @Encoded String destination, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        destination = Codec.decode((String)destination);
        return this.getPartitionedTopicMetadata(property, cluster, namespace, destination, authoritative);
    }

    @GET
    @Path(value="{property}/{cluster}/{namespace}/{destination}/stats")
    @ApiOperation(value="Get the stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public NonPersistentTopicStats getStats(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="destination") @Encoded String destination, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        destination = Codec.decode((String)destination);
        DestinationName dn = DestinationName.get((String)this.domain(), (String)property, (String)cluster, (String)namespace, (String)destination);
        this.validateAdminOperationOnDestination(dn, authoritative);
        Topic topic = this.getTopicReference(dn);
        return ((NonPersistentTopic)topic).getStats();
    }

    @Override
    @GET
    @Path(value="{property}/{cluster}/{namespace}/{destination}/internalStats")
    @ApiOperation(value="Get the internal stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public PersistentTopicInternalStats getInternalStats(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="destination") @Encoded String destination, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        destination = Codec.decode((String)destination);
        DestinationName dn = DestinationName.get((String)this.domain(), (String)property, (String)cluster, (String)namespace, (String)destination);
        this.validateAdminOperationOnDestination(dn, authoritative);
        Topic topic = this.getTopicReference(dn);
        return topic.getInternalStats();
    }

    @Override
    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/{destination}/partitions")
    @ApiOperation(value="Create a partitioned topic.", notes="It needs to be called before creating a producer on a partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Partitioned topic already exist")})
    public void createPartitionedTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="destination") @Encoded String destination, int numPartitions, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        destination = Codec.decode((String)destination);
        DestinationName dn = DestinationName.get((String)this.domain(), (String)property, (String)cluster, (String)namespace, (String)destination);
        this.validateAdminAccessOnProperty(dn.getProperty());
        if (numPartitions <= 1) {
            throw new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be more than 1");
        }
        try {
            String path = NonPersistentTopics.path("partitioned-topics", property, cluster, namespace, this.domain(), dn.getEncodedLocalName());
            byte[] data = NonPersistentTopics.jsonMapper().writeValueAsBytes((Object)new PartitionedTopicMetadata(numPartitions));
            this.zkCreateOptimistic(path, data);
            Thread.sleep(1000L);
            log.info("[{}] Successfully created partitioned topic {}", (Object)this.clientAppId(), (Object)dn);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            log.warn("[{}] Failed to create already existing partitioned topic {}", (Object)this.clientAppId(), (Object)dn);
            throw new RestException(Response.Status.CONFLICT, "Partitioned topic already exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), dn, e});
            throw new RestException(e);
        }
    }

    @Override
    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/{destination}/unload")
    @ApiOperation(value="Unload a topic")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public void unloadTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="destination") @Encoded String destination, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        log.info("[{}] Unloading topic {}/{}/{}/{}", new Object[]{this.clientAppId(), property, cluster, namespace, destination});
        destination = Codec.decode((String)destination);
        DestinationName dn = DestinationName.get((String)this.domain(), (String)property, (String)cluster, (String)namespace, (String)destination);
        this.unloadTopic(dn, authoritative);
    }

    @Override
    protected void validateAdminOperationOnDestination(DestinationName fqdn, boolean authoritative) {
        this.validateAdminAccessOnProperty(fqdn.getProperty());
        this.validateDestinationOwnership(fqdn, authoritative);
    }

    private Topic getTopicReference(DestinationName dn) {
        try {
            Topic topic = this.pulsar().getBrokerService().getTopicReference(dn.toString());
            Preconditions.checkNotNull((Object)topic);
            return topic;
        }
        catch (Exception exception) {
            throw new RestException(Response.Status.NOT_FOUND, "Topic not found");
        }
    }
}

