/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.BrokerHostUsage;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceAllocationPolicies;
import org.apache.pulsar.broker.stats.metrics.JvmMetrics;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.VM;

public class LoadManagerShared {
    public static final Logger log = LoggerFactory.getLogger(LoadManagerShared.class);
    public static final int MIBI = 0x100000;
    private static final Set<String> primariesCache = new HashSet<String>();
    private static final Set<String> sharedCache = new HashSet<String>();

    private LoadManagerShared() {
    }

    public static synchronized void applyPolicies(ServiceUnitId serviceUnit, SimpleResourceAllocationPolicies policies, Set<String> brokerCandidateCache, Set<String> availableBrokers, BrokerTopicLoadingPredicate brokerTopicLoadingPredicate) {
        boolean isNonPersistentTopic;
        primariesCache.clear();
        sharedCache.clear();
        NamespaceName namespace = serviceUnit.getNamespaceObject();
        boolean isIsolationPoliciesPresent = policies.IsIsolationPoliciesPresent(namespace);
        boolean bl = isNonPersistentTopic = serviceUnit instanceof NamespaceBundle ? ((NamespaceBundle)serviceUnit).hasNonPersistentTopic() : false;
        if (isIsolationPoliciesPresent) {
            log.debug("Isolation Policies Present for namespace - [{}]", (Object)namespace.toString());
        }
        for (String broker : availableBrokers) {
            URL brokerUrl;
            String brokerUrlString = String.format("http://%s", broker);
            try {
                brokerUrl = new URL(brokerUrlString);
            }
            catch (MalformedURLException e) {
                log.error("Unable to parse brokerUrl from ResourceUnitId - [{}]", (Throwable)e);
                continue;
            }
            if (isIsolationPoliciesPresent) {
                if (policies.isPrimaryBroker(namespace, brokerUrl.getHost())) {
                    primariesCache.add(broker);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Added Primary Broker - [{}] as possible Candidates for namespace - [{}] with policies", (Object)brokerUrl.getHost(), (Object)namespace.toString());
                    continue;
                }
                if (policies.isSharedBroker(brokerUrl.getHost())) {
                    sharedCache.add(broker);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Added Shared Broker - [{}] as possible Candidates for namespace - [{}] with policies", (Object)brokerUrl.getHost(), (Object)namespace.toString());
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Skipping Broker - [{}] not primary broker and not shared for namespace - [{}] ", (Object)brokerUrl.getHost(), (Object)namespace.toString());
                continue;
            }
            if (isNonPersistentTopic && !brokerTopicLoadingPredicate.isEnableNonPersistentTopics(brokerUrlString)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Filter broker- [{}] because it doesn't support non-persistent namespace - [{}]", (Object)brokerUrl.getHost(), (Object)namespace.toString());
                continue;
            }
            if (!isNonPersistentTopic && !brokerTopicLoadingPredicate.isEnablePersistentTopics(brokerUrlString)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Filter broker- [{}] because broker only supports non-persistent namespace - [{}]", (Object)brokerUrl.getHost(), (Object)namespace.toString());
                continue;
            }
            if (!policies.isSharedBroker(brokerUrl.getHost())) continue;
            sharedCache.add(broker);
            if (!log.isDebugEnabled()) continue;
            log.debug("Added Shared Broker - [{}] as possible Candidates for namespace - [{}]", (Object)brokerUrl.getHost(), (Object)namespace.toString());
        }
        if (isIsolationPoliciesPresent) {
            brokerCandidateCache.addAll(primariesCache);
            if (policies.shouldFailoverToSecondaries(namespace, primariesCache.size())) {
                log.debug("Not enough of primaries [{}] available for namespace - [{}], adding shared [{}] as possible candidate owners", new Object[]{primariesCache.size(), namespace.toString(), sharedCache.size()});
                brokerCandidateCache.addAll(sharedCache);
            }
        } else {
            log.debug("Policies not present for namespace - [{}] so only considering shared [{}] brokers for possible owner", (Object)namespace.toString(), (Object)sharedCache.size());
            brokerCandidateCache.addAll(sharedCache);
        }
    }

    public static void fillNamespaceToBundlesMap(Set<String> bundles, Map<String, Set<String>> target) {
        bundles.forEach(bundleName -> {
            String namespaceName = LoadManagerShared.getNamespaceNameFromBundleName(bundleName);
            String bundleRange = LoadManagerShared.getBundleRangeFromBundleName(bundleName);
            target.computeIfAbsent(namespaceName, k -> new HashSet()).add(bundleRange);
        });
    }

    public static String getBundleRangeFromBundleName(String bundleName) {
        int pos = bundleName.lastIndexOf("/");
        Preconditions.checkArgument((pos != -1 ? 1 : 0) != 0);
        return bundleName.substring(pos + 1, bundleName.length());
    }

    public static String getNamespaceNameFromBundleName(String bundleName) {
        int pos = bundleName.lastIndexOf(47);
        Preconditions.checkArgument((pos != -1 ? 1 : 0) != 0);
        return bundleName.substring(0, pos);
    }

    public static SystemResourceUsage getSystemResourceUsage(BrokerHostUsage brokerHostUsage) throws IOException {
        SystemResourceUsage systemResourceUsage = brokerHostUsage.getBrokerHostUsage();
        long maxHeapMemoryInBytes = Runtime.getRuntime().maxMemory();
        long memoryUsageInBytes = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        systemResourceUsage.memory.usage = (double)memoryUsageInBytes / 1048576.0;
        systemResourceUsage.memory.limit = (double)maxHeapMemoryInBytes / 1048576.0;
        systemResourceUsage.directMemory.usage = JvmMetrics.getJvmDirectMemoryUsed() / 0x100000L;
        systemResourceUsage.directMemory.limit = VM.maxDirectMemory() / 0x100000L;
        return systemResourceUsage;
    }

    public static boolean isUnloadDisabledInLoadShedding(PulsarService pulsar) {
        if (!pulsar.getConfiguration().isLoadBalancerEnabled()) {
            return true;
        }
        boolean unloadDisabledInLoadShedding = false;
        try {
            unloadDisabledInLoadShedding = pulsar.getGlobalZkCache().exists("/admin/flags/load-shedding-unload-disabled");
        }
        catch (Exception e) {
            log.warn("Unable to fetch contents of [{}] from global zookeeper", (Object)"/admin/flags/load-shedding-unload-disabled", (Object)e);
        }
        return unloadDisabledInLoadShedding;
    }

    public static void removeMostServicingBrokersForNamespace(String assignedBundleName, Set<String> candidates, Map<String, Map<String, Set<String>>> brokerToNamespaceToBundleRange) {
        if (candidates.isEmpty()) {
            return;
        }
        String namespaceName = LoadManagerShared.getNamespaceNameFromBundleName(assignedBundleName);
        int leastBundles = Integer.MAX_VALUE;
        for (String broker2 : candidates) {
            if (brokerToNamespaceToBundleRange.containsKey(broker2)) {
                Set<String> bundleRanges = brokerToNamespaceToBundleRange.get(broker2).get(namespaceName);
                if (bundleRanges == null) {
                    leastBundles = 0;
                    break;
                }
                leastBundles = Math.min(leastBundles, bundleRanges.size());
                continue;
            }
            leastBundles = 0;
            break;
        }
        if (leastBundles == 0) {
            candidates.removeIf(broker -> brokerToNamespaceToBundleRange.containsKey(broker) && ((Map)brokerToNamespaceToBundleRange.get(broker)).containsKey(namespaceName));
        } else {
            int finalLeastBundles = leastBundles;
            candidates.removeIf(broker -> ((Set)((Map)brokerToNamespaceToBundleRange.get(broker)).get(namespaceName)).size() != finalLeastBundles);
        }
    }

    static interface BrokerTopicLoadingPredicate {
        public boolean isEnablePersistentTopics(String var1);

        public boolean isEnableNonPersistentTopics(String var1);
    }
}

