/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.common.api.PulsarLengthFieldFrameDecoder;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    BrokerService brokerService;
    ServiceConfiguration serviceConfig;
    boolean enableTLS;

    public PulsarChannelInitializer(BrokerService brokerService, ServiceConfiguration serviceConfig, boolean enableTLS) {
        this.brokerService = brokerService;
        this.serviceConfig = serviceConfig;
        this.enableTLS = enableTLS;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.enableTLS) {
            File tlsCert = new File(this.serviceConfig.getTlsCertificateFilePath());
            File tlsKey = new File(this.serviceConfig.getTlsKeyFilePath());
            SslContextBuilder builder = SslContextBuilder.forServer((File)tlsCert, (File)tlsKey);
            if (this.serviceConfig.isTlsAllowInsecureConnection()) {
                builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            } else if (this.serviceConfig.getTlsTrustCertsFilePath().isEmpty()) {
                builder.trustManager(null);
            } else {
                File trustCertCollection = new File(this.serviceConfig.getTlsTrustCertsFilePath());
                builder.trustManager(trustCertCollection);
            }
            SslContext sslCtx = builder.clientAuth(ClientAuth.OPTIONAL).build();
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)sslCtx.newHandler(ch.alloc()));
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new PulsarLengthFieldFrameDecoder(0x500000, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new ServerCnx(this.brokerService));
    }
}

