/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.common.api.proto.PulsarApi;

public interface Subscription {
    public String getName();

    public void addConsumer(Consumer var1) throws BrokerServiceException;

    public void removeConsumer(Consumer var1) throws BrokerServiceException;

    public void consumerFlow(Consumer var1, int var2);

    public void acknowledgeMessage(PositionImpl var1, PulsarApi.CommandAck.AckType var2);

    public String getDestination();

    public Dispatcher getDispatcher();

    public long getNumberOfEntriesInBacklog();

    public List<Consumer> getConsumers();

    public CompletableFuture<Void> close();

    public CompletableFuture<Void> delete();

    public CompletableFuture<Void> disconnect();

    public CompletableFuture<Void> doUnsubscribe(Consumer var1);

    public CompletableFuture<Void> clearBacklog();

    public CompletableFuture<Void> skipMessages(int var1);

    public CompletableFuture<Void> resetCursor(long var1);

    public CompletableFuture<Entry> peekNthMessage(int var1);

    public void expireMessages(int var1);

    public void redeliverUnacknowledgedMessages(Consumer var1);

    public void redeliverUnacknowledgedMessages(Consumer var1, List<PositionImpl> var2);

    public void markTopicWithBatchMessagePublished();

    public double getExpiredMessageRate();

    public PulsarApi.CommandSubscribe.SubType getType();

    public String getTypeString();

    public void addUnAckedMessages(int var1);
}

