/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.AbstractDispatcherSingleActiveConsumer;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.util.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistentDispatcherSingleActiveConsumer
extends AbstractDispatcherSingleActiveConsumer
implements Dispatcher,
AsyncCallbacks.ReadEntriesCallback {
    private final PersistentTopic topic;
    private final ManagedCursor cursor;
    private final String name;
    private boolean havePendingRead = false;
    private static final int MaxReadBatchSize = 100;
    private int readBatchSize;
    private final Backoff readFailureBackoff = new Backoff(15L, TimeUnit.SECONDS, 1L, TimeUnit.MINUTES, 0L, TimeUnit.MILLISECONDS);
    private final ServiceConfiguration serviceConfig;
    private static final Logger log = LoggerFactory.getLogger(PersistentDispatcherSingleActiveConsumer.class);

    public PersistentDispatcherSingleActiveConsumer(ManagedCursor cursor, PulsarApi.CommandSubscribe.SubType subscriptionType, int partitionIndex, PersistentTopic topic) {
        super(subscriptionType, partitionIndex, topic.getName());
        this.topic = topic;
        this.name = String.valueOf(topic.getName()) + " / " + (cursor.getName() != null ? Codec.decode((String)cursor.getName()) : "");
        this.cursor = cursor;
        this.readBatchSize = 100;
        this.serviceConfig = topic.getBrokerService().pulsar().getConfiguration();
    }

    @Override
    protected void scheduleReadOnActiveConsumer() {
        if (this.havePendingRead && this.cursor.cancelPendingReadRequest()) {
            this.havePendingRead = false;
        }
        if (!this.havePendingRead) {
            this.cursor.rewind();
            this.readMoreEntries(AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this));
        }
    }

    @Override
    protected void cancelPendingRead() {
        if (this.havePendingRead && this.cursor.cancelPendingReadRequest()) {
            this.havePendingRead = false;
        }
    }

    public synchronized void readEntriesComplete(List<Entry> entries, Object obj) {
        Consumer readConsumer = (Consumer)obj;
        if (log.isDebugEnabled()) {
            log.debug("[{}-{}] Got messages: {}", new Object[]{this.name, readConsumer, entries.size()});
        }
        this.havePendingRead = false;
        if (this.readBatchSize < 100) {
            int newReadBatchSize = Math.min(this.readBatchSize * 2, 100);
            if (log.isDebugEnabled()) {
                log.debug("[{}-{}] Increasing read batch size from {} to {}", new Object[]{this.name, readConsumer, this.readBatchSize, newReadBatchSize});
            }
            this.readBatchSize = newReadBatchSize;
        }
        this.readFailureBackoff.reduceToHalf();
        Consumer currentConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
        if (currentConsumer == null || readConsumer != currentConsumer) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] rewind because no available consumer found", (Object)this.name);
            }
            entries.forEach(Entry::release);
            this.cursor.rewind();
            if (currentConsumer != null) {
                this.readMoreEntries(currentConsumer);
            }
        } else {
            Consumer.SendMessageInfo sentMsgInfo = currentConsumer.sendMessages(entries);
            long totalMessagesSent = sentMsgInfo.getTotalSentMessages();
            long totalBytesSent = sentMsgInfo.getTotalSentMessageBytes();
            sentMsgInfo.getChannelPromse().addListener(future -> {
                if (future.isSuccess()) {
                    if (this.serviceConfig.isDispatchThrottlingOnNonBacklogConsumerEnabled() || !this.cursor.isActive()) {
                        this.topic.getDispatchRateLimiter().tryDispatchPermit(totalMessagesSent, totalBytesSent);
                    }
                    PersistentDispatcherSingleActiveConsumer persistentDispatcherSingleActiveConsumer = this;
                    synchronized (persistentDispatcherSingleActiveConsumer) {
                        Consumer newConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
                        if (newConsumer != null && !this.havePendingRead) {
                            this.readMoreEntries(newConsumer);
                        } else if (log.isDebugEnabled()) {
                            log.debug("[{}-{}] Ignoring write future complete. consumerAvailable={} havePendingRead={}", new Object[]{this.name, newConsumer, newConsumer != null, this.havePendingRead});
                        }
                    }
                }
            });
        }
    }

    @Override
    public synchronized void consumerFlow(Consumer consumer, int additionalNumberOfMessages) {
        if (!this.havePendingRead) {
            if (AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this) == consumer) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}-{}] Trigger new read after receiving flow control message", (Object)this.name, (Object)consumer);
                }
                this.readMoreEntries(consumer);
            } else if (log.isDebugEnabled()) {
                log.debug("[{}-{}] Ignoring flow control message since consumer is not active partition consumer", (Object)this.name, (Object)consumer);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("[{}-{}] Ignoring flow control message since we already have a pending read req", (Object)this.name, (Object)consumer);
        }
    }

    @Override
    public synchronized void redeliverUnacknowledgedMessages(Consumer consumer) {
        if (consumer != AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this)) {
            log.info("[{}] Ignoring reDeliverUnAcknowledgedMessages: Only the active consumer can call resend", (Object)consumer);
            return;
        }
        if (this.havePendingRead && this.cursor.cancelPendingReadRequest()) {
            this.havePendingRead = false;
        }
        if (!this.havePendingRead) {
            this.cursor.rewind();
            if (log.isDebugEnabled()) {
                log.debug("[{}-{}] Cursor rewinded, redelivering unacknowledged messages. ", (Object)this.name, (Object)consumer);
            }
            this.readMoreEntries(consumer);
        } else {
            log.info("[{}-{}] Ignoring reDeliverUnAcknowledgedMessages: cancelPendingRequest on cursor failed", (Object)this.name, (Object)consumer);
        }
    }

    @Override
    public void redeliverUnacknowledgedMessages(Consumer consumer, List<PositionImpl> positions) {
        this.redeliverUnacknowledgedMessages(consumer);
    }

    @Override
    protected void readMoreEntries(Consumer consumer) {
        int availablePermits = consumer.getAvailablePermits();
        if (availablePermits > 0) {
            DispatchRateLimiter rateLimiter;
            if (!consumer.isWritable()) {
                availablePermits = 1;
            }
            int messagesToRead = Math.min(availablePermits, this.readBatchSize);
            if ((this.serviceConfig.isDispatchThrottlingOnNonBacklogConsumerEnabled() || !this.cursor.isActive()) && (rateLimiter = this.topic.getDispatchRateLimiter()).isDispatchRateLimitingEnabled()) {
                if (!rateLimiter.hasMessageDispatchPermit()) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] message-read exceeded message-rate {}/{}, schedule after a {}", new Object[]{this.name, rateLimiter.getDispatchRateOnMsg(), rateLimiter.getDispatchRateOnByte(), 1000});
                    }
                    this.topic.getBrokerService().executor().schedule(() -> {
                        Consumer currentConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
                        if (currentConsumer != null && !this.havePendingRead) {
                            this.readMoreEntries(currentConsumer);
                        } else if (log.isDebugEnabled()) {
                            log.info("[{}] Skipping read retry: Current Consumer {}, havePendingRead {}", new Object[]{this.topic.getName(), currentConsumer, this.havePendingRead});
                        }
                    }, 1000L, TimeUnit.MILLISECONDS);
                    return;
                }
                long availablePermitsOnMsg = rateLimiter.getAvailableDispatchRateLimitOnMsg();
                if (availablePermitsOnMsg > 0L) {
                    messagesToRead = Math.min(messagesToRead, (int)availablePermitsOnMsg);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}-{}] Schedule read of {} messages", new Object[]{this.name, consumer, messagesToRead});
            }
            this.havePendingRead = true;
            this.cursor.asyncReadEntriesOrWait(messagesToRead, (AsyncCallbacks.ReadEntriesCallback)this, (Object)consumer);
        } else if (log.isDebugEnabled()) {
            log.debug("[{}-{}] Consumer buffer is full, pause reading", (Object)this.name, (Object)consumer);
        }
    }

    public synchronized void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
        this.havePendingRead = false;
        Consumer c = (Consumer)ctx;
        long waitTimeMillis = this.readFailureBackoff.next();
        if (exception instanceof ManagedLedgerException.NoMoreEntriesToReadException) {
            if (this.cursor.getNumberOfEntriesInBacklog() == 0L) {
                this.consumers.forEach(Consumer::reachedEndOfTopic);
            }
        } else if (!(exception instanceof ManagedLedgerException.TooManyRequestsException)) {
            log.error("[{}-{}] Error reading entries at {} : {} - Retrying to read in {} seconds", new Object[]{this.name, c, this.cursor.getReadPosition(), exception.getMessage(), (double)waitTimeMillis / 1000.0});
        } else if (log.isDebugEnabled()) {
            log.debug("[{}-{}] Got throttled by bookies while reading at {} : {} - Retrying to read in {} seconds", new Object[]{this.name, c, this.cursor.getReadPosition(), exception.getMessage(), (double)waitTimeMillis / 1000.0});
        }
        Preconditions.checkNotNull((Object)c);
        this.readBatchSize = 1;
        this.topic.getBrokerService().executor().schedule(() -> {
            PersistentDispatcherSingleActiveConsumer persistentDispatcherSingleActiveConsumer = this;
            synchronized (persistentDispatcherSingleActiveConsumer) {
                Consumer currentConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
                if (currentConsumer != null && !this.havePendingRead) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}-{}] Retrying read operation", (Object)this.name, (Object)c);
                    }
                    this.readMoreEntries(currentConsumer);
                } else {
                    log.info("[{}-{}] Skipping read retry: Current Consumer {}, havePendingRead {}", new Object[]{this.name, c, currentConsumer, this.havePendingRead});
                }
            }
        }, waitTimeMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void addUnAckedMessages(int unAckMessages) {
    }
}

