/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import com.google.common.collect.Maps;
import io.netty.util.Recycler;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.common.stats.Metrics;

public class ReplicationMetrics {
    public double msgRateOut;
    public double msgThroughputOut;
    public double msgReplBacklog;
    public int connected;
    private final Recycler.Handle recyclerHandle;
    private static final Recycler<ReplicationMetrics> RECYCLER = new Recycler<ReplicationMetrics>(){

        protected ReplicationMetrics newObject(Recycler.Handle handle) {
            return new ReplicationMetrics(handle, null);
        }
    };

    public void reset() {
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.msgReplBacklog = 0.0;
        this.connected = 0;
    }

    public static ReplicationMetrics get() {
        ReplicationMetrics replicationMetrics = (ReplicationMetrics)RECYCLER.get();
        replicationMetrics.reset();
        return replicationMetrics;
    }

    private ReplicationMetrics(Recycler.Handle recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void recycle() {
        this.msgRateOut = -1.0;
        this.msgThroughputOut = -1.0;
        this.msgReplBacklog = -1.0;
        this.connected = -1;
        RECYCLER.recycle((Object)this, this.recyclerHandle);
    }

    public Metrics add(String namespace, String local, String remote) {
        HashMap dimensionMap = Maps.newHashMap();
        dimensionMap.put("namespace", namespace);
        dimensionMap.put("from_cluster", local);
        dimensionMap.put("to_cluster", remote);
        Metrics dMetrics = Metrics.create((Map)dimensionMap);
        dMetrics.put("brk_repl_out_rate", (Object)this.msgRateOut);
        dMetrics.put("brk_repl_out_tp_rate", (Object)this.msgThroughputOut);
        dMetrics.put("brk_replication_backlog", (Object)this.msgReplBacklog);
        dMetrics.put("brk_repl_is_connected", (Object)this.connected);
        return dMetrics;
    }

    /* synthetic */ ReplicationMetrics(Recycler.Handle handle, ReplicationMetrics replicationMetrics) {
        this(handle);
    }
}

