/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.cache.LocalZooKeeperCacheService;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PropertyAdmin;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperChildrenCache;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdminResource
extends PulsarWebResource {
    private static final Logger log = LoggerFactory.getLogger(AdminResource.class);
    private static final String POLICIES_READONLY_FLAG_PATH = "/admin/flags/policies-readonly";
    public static final String LOAD_SHEDDING_UNLOAD_DISABLED_FLAG_PATH = "/admin/flags/load-shedding-unload-disabled";
    public static final String PARTITIONED_TOPIC_PATH_ZNODE = "partitioned-topics";

    protected ZooKeeper globalZk() {
        return this.pulsar().getGlobalZkCache().getZooKeeper();
    }

    protected ZooKeeperCache globalZkCache() {
        return this.pulsar().getGlobalZkCache();
    }

    protected ZooKeeper localZk() {
        return this.pulsar().getZkClient();
    }

    protected ZooKeeperCache localZkCache() {
        return this.pulsar().getLocalZkCache();
    }

    protected LocalZooKeeperCacheService localCacheService() {
        return this.pulsar().getLocalZkCacheService();
    }

    protected void zkCreate(String path, byte[] content) throws Exception {
        this.globalZk().create(path, content, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    protected void zkCreateOptimistic(String path, byte[] content) throws Exception {
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.globalZk(), (String)path, (byte[])content, ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
    }

    protected String domain() {
        if (this.uri.getPath().startsWith("persistent/")) {
            return "persistent";
        }
        if (this.uri.getPath().startsWith("non-persistent/")) {
            return "non-persistent";
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "domain() invoked from wrong resource");
    }

    @Override
    protected void validateSuperUserAccess() {
        super.validateSuperUserAccess();
    }

    @Override
    protected void validateAdminAccessOnProperty(String property) {
        super.validateAdminAccessOnProperty(property);
    }

    @Override
    protected void validateNamespaceOwnershipWithBundles(String property, String cluster, String namespace, boolean authoritative, boolean readOnly, BundlesData bundleData) {
        super.validateNamespaceOwnershipWithBundles(property, cluster, namespace, authoritative, readOnly, bundleData);
    }

    @Override
    protected void validateBundleOwnership(String property, String cluster, String namespace, boolean authoritative, boolean readOnly, NamespaceBundle bundle) {
        super.validateBundleOwnership(property, cluster, namespace, authoritative, readOnly, bundle);
    }

    @Override
    protected boolean isLeaderBroker() {
        return super.isLeaderBroker();
    }

    public void validatePoliciesReadOnlyAccess() {
        boolean arePoliciesReadOnly = true;
        try {
            arePoliciesReadOnly = this.globalZkCache().exists(POLICIES_READONLY_FLAG_PATH);
        }
        catch (Exception e) {
            log.warn("Unable to fetch contents of [{}] from global zookeeper", (Object)POLICIES_READONLY_FLAG_PATH, (Object)e);
            throw new RestException(e);
        }
        if (arePoliciesReadOnly) {
            log.debug("Policies are read-only. Broker cannot do read-write operations");
            throw new RestException(Response.Status.FORBIDDEN, "Broker is forbidden to do read-write operations");
        }
        if (this.globalZkCache().getZooKeeper().getState() != ZooKeeper.States.CONNECTED) {
            log.debug("Broker is not connected to the global zookeeper");
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Broker needs to be connected to global zookeeper before making a read-write operation");
        }
        log.debug("Broker is allowed to make read-write operations");
    }

    protected List<String> getListOfNamespaces(String property) throws Exception {
        ArrayList namespaces = Lists.newArrayList();
        for (String cluster : this.globalZk().getChildren(AdminResource.path("policies", property), false)) {
            try {
                for (String namespace : this.globalZk().getChildren(AdminResource.path("policies", property, cluster), false)) {
                    namespaces.add(String.format("%s/%s/%s", property, cluster, namespace));
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {}
        }
        namespaces.sort(null);
        return namespaces;
    }

    protected void validateBrokerName(String broker) throws MalformedURLException {
        String brokerUrl = String.format("http://%s", broker);
        if (!this.pulsar().getWebServiceAddress().equals(brokerUrl)) {
            String[] parts = broker.split(":");
            Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid broker url %s", (Object)broker);
            String host = parts[0];
            int port = Integer.parseInt(parts[1]);
            URI redirect = UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(host).port(port).build(new Object[0]);
            log.debug("[{}] Redirecting the rest call to {}: broker={}", new Object[]{this.clientAppId(), redirect, broker});
            throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
        }
    }

    protected Policies getNamespacePolicies(String property, String cluster, String namespace) {
        try {
            Policies policies = (Policies)this.policiesCache().get(AdminResource.path("policies", property, cluster, namespace)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(new NamespaceName(property, cluster, namespace));
            BundlesData bundleData = NamespaceBundleFactory.getBundlesData(bundles);
            policies.bundles = bundleData != null ? bundleData : policies.bundles;
            return policies;
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespace policies {}/{}/{}", new Object[]{this.clientAppId(), property, cluster, namespace, e});
            throw new RestException(e);
        }
    }

    public static ObjectMapper jsonMapper() {
        return ObjectMapperFactory.getThreadLocal();
    }

    ZooKeeperDataCache<PropertyAdmin> propertiesCache() {
        return this.pulsar().getConfigurationCache().propertiesCache();
    }

    ZooKeeperDataCache<Policies> policiesCache() {
        return this.pulsar().getConfigurationCache().policiesCache();
    }

    ZooKeeperDataCache<LocalPolicies> localPoliciesCache() {
        return this.pulsar().getLocalZkCacheService().policiesCache();
    }

    ZooKeeperDataCache<ClusterData> clustersCache() {
        return this.pulsar().getConfigurationCache().clustersCache();
    }

    ZooKeeperChildrenCache managedLedgerListCache() {
        return this.pulsar().getLocalZkCacheService().managedLedgerListCache();
    }

    Set<String> clusters() {
        try {
            return this.pulsar().getConfigurationCache().clustersListCache().get();
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    ZooKeeperChildrenCache clustersListCache() {
        return this.pulsar().getConfigurationCache().clustersListCache();
    }

    protected void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected ZooKeeperDataCache<NamespaceIsolationPolicies> namespaceIsolationPoliciesCache() {
        return this.pulsar().getConfigurationCache().namespaceIsolationPoliciesCache();
    }

    protected PartitionedTopicMetadata getPartitionedTopicMetadata(String property, String cluster, String namespace, String destination, boolean authoritative) {
        DestinationName dn = DestinationName.get((String)this.domain(), (String)property, (String)cluster, (String)namespace, (String)destination);
        this.validateClusterOwnership(dn.getCluster());
        this.validateGlobalNamespaceOwnership(dn.getNamespaceObject());
        try {
            this.checkConnect(dn);
        }
        catch (WebApplicationException webApplicationException) {
            this.validateAdminAccessOnProperty(dn.getProperty());
        }
        catch (Exception e) {
            log.warn("Unexpected error while authorizing lookup. destination={}, role={}. Error: {}", new Object[]{destination, this.clientAppId(), e.getMessage(), e});
            throw new RestException(e);
        }
        String path = AdminResource.path(PARTITIONED_TOPIC_PATH_ZNODE, property, cluster, namespace, this.domain(), dn.getEncodedLocalName());
        PartitionedTopicMetadata partitionMetadata = AdminResource.fetchPartitionedTopicMetadata(this.pulsar(), path);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Total number of partitions for topic {} is {}", new Object[]{this.clientAppId(), dn, partitionMetadata.partitions});
        }
        return partitionMetadata;
    }

    protected static PartitionedTopicMetadata fetchPartitionedTopicMetadata(PulsarService pulsar, String path) {
        try {
            return AdminResource.fetchPartitionedTopicMetadataAsync(pulsar, path).get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof RestException) {
                throw (RestException)((Object)e);
            }
            throw new RestException(e);
        }
    }

    protected static CompletableFuture<PartitionedTopicMetadata> fetchPartitionedTopicMetadataAsync(PulsarService pulsar, String path) {
        CompletableFuture<PartitionedTopicMetadata> metadataFuture = new CompletableFuture<PartitionedTopicMetadata>();
        try {
            ((CompletableFuture)pulsar.getGlobalZkCache().getDataAsync(path, (ZooKeeperCache.Deserializer)new ZooKeeperCache.Deserializer<PartitionedTopicMetadata>(){

                public PartitionedTopicMetadata deserialize(String key, byte[] content) throws Exception {
                    return (PartitionedTopicMetadata)AdminResource.jsonMapper().readValue(content, PartitionedTopicMetadata.class);
                }
            }).thenAccept(metadata -> {
                if (metadata.isPresent()) {
                    metadataFuture.complete((PartitionedTopicMetadata)metadata.get());
                } else {
                    metadataFuture.complete(new PartitionedTopicMetadata());
                }
            })).exceptionally(ex -> {
                metadataFuture.completeExceptionally((Throwable)ex);
                return null;
            });
        }
        catch (Exception e) {
            metadataFuture.completeExceptionally(e);
        }
        return metadataFuture;
    }
}

