/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.util.Map;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.loadbalance.LoadReport;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.ServiceUnit;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.NamespaceIsolationPolicy;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleResourceAllocationPolicies {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleResourceAllocationPolicies.class);
    private final ZooKeeperDataCache<NamespaceIsolationPolicies> namespaceIsolationPolicies;
    private final PulsarService pulsar;

    public SimpleResourceAllocationPolicies(PulsarService pulsar) {
        this.namespaceIsolationPolicies = pulsar.getConfigurationCache().namespaceIsolationPoliciesCache();
        this.pulsar = pulsar;
    }

    public boolean canAssign(ServiceUnit srvUnit, ResourceUnit rescrUnit, Map<ResourceUnit, LoadReport> loadReports) {
        return true;
    }

    private NamespaceIsolationPolicies getIsolationPolicies(String clusterName) {
        NamespaceIsolationPolicies policies = null;
        try {
            policies = this.namespaceIsolationPolicies.get(AdminResource.path("clusters", clusterName, "namespaceIsolationPolicies")).orElse(null);
        }
        catch (Exception e) {
            LOG.warn("GetIsolationPolicies: Unable to get the namespaceIsolationPolicies [{}]", (Throwable)e);
        }
        return policies;
    }

    public boolean IsIsolationPoliciesPresent(NamespaceName namespace) {
        try {
            NamespaceIsolationPolicies policies = null;
            policies = this.getIsolationPolicies(this.pulsar.getConfiguration().getClusterName());
            if (policies != null) {
                return policies.getPolicyByNamespace(namespace) != null;
            }
        }
        catch (Exception e) {
            LOG.warn("IsIsolationPoliciesPresent: Unable to get the namespaceIsolationPolicies [{}]", (Throwable)e);
        }
        return false;
    }

    private NamespaceIsolationPolicy getNamespaceIsolationPolicy(NamespaceName namespace) {
        NamespaceIsolationPolicies policies = null;
        NamespaceIsolationPolicy policy = null;
        try {
            policies = this.getIsolationPolicies(this.pulsar.getConfiguration().getClusterName());
            policy = policies.getPolicyByNamespace(namespace);
        }
        catch (Exception e) {
            LOG.warn("Unable to get the namespaceIsolationPolicies [{}]", (Throwable)e);
        }
        return policy;
    }

    public boolean isPrimaryBroker(NamespaceName namespace, String broker) {
        NamespaceIsolationPolicy nsPolicy = this.getNamespaceIsolationPolicy(namespace);
        return nsPolicy != null ? nsPolicy.isPrimaryBroker(broker) : false;
    }

    public boolean isSecondaryBroker(NamespaceName namespace, String broker) {
        NamespaceIsolationPolicy nsPolicy = this.getNamespaceIsolationPolicy(namespace);
        return nsPolicy != null ? nsPolicy.isSecondaryBroker(broker) : false;
    }

    public boolean isSharedBroker(String broker) {
        NamespaceIsolationPolicies policies;
        block3: {
            try {
                policies = this.getIsolationPolicies(this.pulsar.getConfiguration().getClusterName());
                if (policies != null) break block3;
                return true;
            }
            catch (Exception e) {
                LOG.warn("isPrimaryForAnyNamespace: [{}]", (Throwable)e);
                return false;
            }
        }
        return policies.isSharedBroker(broker);
    }

    public boolean shouldFailoverToSecondaries(NamespaceName namespace, int totalPrimaryCandidates) {
        NamespaceIsolationPolicy nsPolicy = this.getNamespaceIsolationPolicy(namespace);
        return nsPolicy != null ? nsPolicy.shouldFailover(totalPrimaryCandidates) : false;
    }
}

