/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.metrics.JvmMetrics;
import org.apache.pulsar.broker.stats.prometheus.NamespaceStatsAggregator;
import org.apache.pulsar.utils.SimpleTextOutputStream;
import sun.misc.VM;

public class PrometheusMetricsGenerator {
    static {
        DefaultExports.initialize();
        Gauge.build((String)"jvm_memory_direct_bytes_used", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return JvmMetrics.getJvmDirectMemoryUsed();
            }
        }, new String[0]).register(CollectorRegistry.defaultRegistry);
        Gauge.build((String)"jvm_memory_direct_bytes_max", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return VM.maxDirectMemory();
            }
        }, new String[0]).register(CollectorRegistry.defaultRegistry);
    }

    public static void generate(PulsarService pulsar, OutputStream out) throws IOException {
        ByteBuf buf = ByteBufAllocator.DEFAULT.heapBuffer();
        try {
            SimpleTextOutputStream stream = new SimpleTextOutputStream(buf);
            PrometheusMetricsGenerator.generateSystemMetrics(stream, pulsar.getConfiguration().getClusterName());
            NamespaceStatsAggregator.generate(pulsar, stream);
            out.write(buf.array(), buf.arrayOffset(), buf.readableBytes());
        }
        finally {
            buf.release();
        }
    }

    private static void generateSystemMetrics(SimpleTextOutputStream stream, String cluster) {
        Enumeration metricFamilySamples = CollectorRegistry.defaultRegistry.metricFamilySamples();
        while (metricFamilySamples.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamily = (Collector.MetricFamilySamples)metricFamilySamples.nextElement();
            int i = 0;
            while (i < metricFamily.samples.size()) {
                Collector.MetricFamilySamples.Sample sample = (Collector.MetricFamilySamples.Sample)metricFamily.samples.get(i);
                stream.write(sample.name);
                stream.write("{cluster=\"").write(cluster).write("\",");
                int j = 0;
                while (j < sample.labelNames.size()) {
                    stream.write((String)sample.labelNames.get(j));
                    stream.write("=\"");
                    stream.write((String)sample.labelValues.get(j));
                    stream.write("\",");
                    ++j;
                }
                stream.write("} ");
                stream.write(Collector.doubleToGoString((double)sample.value));
                stream.write('\n');
                ++i;
            }
        }
    }
}

