/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import javax.naming.AuthenticationException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    private final AuthenticationService authenticationService;
    public static final String AuthenticatedRoleAttributeName = String.valueOf(AuthenticationFilter.class.getName()) + "-role";

    public AuthenticationFilter(PulsarService pulsar) {
        this.authenticationService = pulsar.getBrokerService().getAuthenticationService();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            String role = this.authenticationService.authenticateHttpRequest((HttpServletRequest)request);
            request.setAttribute(AuthenticatedRoleAttributeName, (Object)role);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[{}] Authenticated HTTP request with role {}", (Object)request.getRemoteAddr(), (Object)role);
            }
        }
        catch (AuthenticationException e) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(401, "Authentication required");
            LOG.warn("[{}] Failed to authenticate HTTP request: {}", (Object)request.getRemoteAddr(), (Object)e.getMessage());
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg) throws ServletException {
    }

    public void destroy() {
    }
}

