/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.PulsarServerConnector;
import org.apache.pulsar.broker.web.ResponseHandlerFilter;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.SecurityUtility;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebService
implements AutoCloseable {
    private static final List<Pattern> API_VERSION_FILTER_PATTERNS = ImmutableList.of((Object)Pattern.compile("^/lookup.*"));
    private static final String MATCH_ALL = "/*";
    public static final String ATTRIBUTE_PULSAR_NAME = "pulsar";
    public static final String HANDLER_CACHE_CONTROL = "max-age=3600";
    public static final int NUM_ACCEPTORS = 32;
    public static final int MAX_CONCURRENT_REQUESTS = 1024;
    private final PulsarService pulsar;
    private final Server server;
    private final List<Handler> handlers = Lists.newArrayList();
    private final ExecutorService webServiceExecutor;
    private static final Logger log = LoggerFactory.getLogger(WebService.class);

    public WebService(PulsarService pulsar) throws PulsarServerException {
        this.pulsar = pulsar;
        this.webServiceExecutor = Executors.newFixedThreadPool(32, (ThreadFactory)new DefaultThreadFactory("pulsar-web"));
        this.server = new Server((ThreadPool)new ExecutorThreadPool(this.webServiceExecutor));
        ArrayList<PulsarServerConnector> connectors = new ArrayList<PulsarServerConnector>();
        PulsarServerConnector connector = new PulsarServerConnector(this.server, 1, 1);
        connector.setPort(pulsar.getConfiguration().getWebServicePort());
        connector.setHost(pulsar.getBindAddress());
        connectors.add(connector);
        if (pulsar.getConfiguration().isTlsEnabled()) {
            SslContextFactory sslCtxFactory = new SslContextFactory();
            try {
                sslCtxFactory.setSslContext(SecurityUtility.createSslContext((boolean)pulsar.getConfiguration().isTlsAllowInsecureConnection(), (String)pulsar.getConfiguration().getTlsTrustCertsFilePath(), (String)pulsar.getConfiguration().getTlsCertificateFilePath(), (String)pulsar.getConfiguration().getTlsKeyFilePath()));
            }
            catch (GeneralSecurityException e) {
                throw new PulsarServerException((Throwable)e);
            }
            sslCtxFactory.setWantClientAuth(true);
            PulsarServerConnector tlsConnector = new PulsarServerConnector(this.server, 1, 1, sslCtxFactory);
            tlsConnector.setPort(pulsar.getConfiguration().getWebServicePortTls());
            tlsConnector.setHost(pulsar.getBindAddress());
            connectors.add(tlsConnector);
        }
        connectors.forEach(c -> c.setAcceptQueueSize(1024 / connectors.size()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
    }

    public void addRestResources(String basePath, String javaPackages, boolean requiresAuthentication) {
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(ObjectMapperFactory.create());
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"jersey.config.server.provider.packages", javaPackages});
        config.register((Object)provider);
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer(config));
        servletHolder.setAsyncSupported(true);
        this.addServlet(basePath, servletHolder, requiresAuthentication);
    }

    public void addServlet(String path, ServletHolder servletHolder, boolean requiresAuthentication) {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(path);
        context.addServlet(servletHolder, MATCH_ALL);
        context.setAttribute(ATTRIBUTE_PULSAR_NAME, (Object)this.pulsar);
        if (requiresAuthentication && this.pulsar.getConfiguration().isAuthenticationEnabled()) {
            FilterHolder filter = new FilterHolder((Filter)new AuthenticationFilter(this.pulsar));
            context.addFilter(filter, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        FilterHolder responseFilter = new FilterHolder((Filter)new ResponseHandlerFilter(this.pulsar));
        context.addFilter(responseFilter, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        this.handlers.add((Handler)context);
    }

    public void addStaticResources(String basePath, String resourcePath) {
        ContextHandler capHandler = new ContextHandler();
        capHandler.setContextPath(basePath);
        ResourceHandler resHandler = new ResourceHandler();
        resHandler.setBaseResource(Resource.newClassPathResource((String)resourcePath));
        resHandler.setEtags(true);
        resHandler.setCacheControl(HANDLER_CACHE_CONTROL);
        capHandler.setHandler((Handler)resHandler);
        this.handlers.add((Handler)capHandler);
    }

    private boolean shouldCheckApiVersionOnPath(String path) {
        for (Pattern filterPattern : API_VERSION_FILTER_PATTERNS) {
            Matcher matcher = filterPattern.matcher(path);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public void start() throws PulsarServerException {
        try {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            Slf4jRequestLog requestLog = new Slf4jRequestLog();
            requestLog.setExtended(true);
            requestLog.setLogTimeZone(TimeZone.getDefault().getID());
            requestLog.setLogLatency(true);
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            this.handlers.add(0, (Handler)new ContextHandlerCollection());
            this.handlers.add((Handler)requestLogHandler);
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
            HandlerCollection handlerCollection = new HandlerCollection();
            handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
            this.server.setHandler((Handler)handlerCollection);
            this.server.start();
            log.info("Web Service started at {}", (Object)this.pulsar.getWebServiceAddress());
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    @Override
    public void close() throws PulsarServerException {
        try {
            this.server.stop();
            this.webServiceExecutor.shutdown();
            log.info("Web service closed");
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }
}

