/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.stats.ClusterReplicationMetrics;
import org.apache.pulsar.broker.stats.NamespaceStats;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.PersistentTopicStats;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.utils.StatsOutputStream;

public interface Topic {
    public void publishMessage(ByteBuf var1, PublishContext var2);

    public void addProducer(Producer var1) throws BrokerServiceException;

    public void removeProducer(Producer var1);

    public CompletableFuture<Consumer> subscribe(ServerCnx var1, String var2, long var3, PulsarApi.CommandSubscribe.SubType var5, int var6, String var7, boolean var8, MessageId var9, Map<String, String> var10, boolean var11);

    public CompletableFuture<Subscription> createSubscription(String var1);

    public CompletableFuture<Void> unsubscribe(String var1);

    public ConcurrentOpenHashMap<String, ? extends Subscription> getSubscriptions();

    public CompletableFuture<Void> delete();

    public ConcurrentOpenHashSet<Producer> getProducers();

    public String getName();

    public CompletableFuture<Void> checkReplication();

    public CompletableFuture<Void> close();

    public void checkGC(int var1);

    public void checkMessageExpiry();

    public void checkMessageDeduplicationInfo();

    public CompletableFuture<Void> onPoliciesUpdate(Policies var1);

    public boolean isBacklogQuotaExceeded(String var1);

    public boolean isEncryptionRequired();

    public BacklogQuota getBacklogQuota();

    public void updateRates(NamespaceStats var1, NamespaceBundleStats var2, StatsOutputStream var3, ClusterReplicationMetrics var4, String var5);

    public Subscription getSubscription(String var1);

    public ConcurrentOpenHashMap<String, ? extends Replicator> getReplicators();

    public PersistentTopicStats getStats();

    public PersistentTopicInternalStats getInternalStats();

    public static interface PublishContext {
        default public String getProducerName() {
            return null;
        }

        default public long getSequenceId() {
            return -1L;
        }

        default public void setOriginalProducerName(String originalProducerName) {
        }

        default public void setOriginalSequenceId(long originalSequenceId) {
        }

        default public String getOriginalProducerName() {
            return null;
        }

        default public long getOriginalSequenceId() {
            return -1L;
        }

        public void completed(Exception var1, long var2, long var4);
    }
}

