/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.nonpersistent;

import java.util.List;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.util.Rate;
import org.apache.pulsar.broker.service.AbstractDispatcherSingleActiveConsumer;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentDispatcher;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.common.api.proto.PulsarApi;

public final class NonPersistentDispatcherSingleActiveConsumer
extends AbstractDispatcherSingleActiveConsumer
implements NonPersistentDispatcher {
    private final Rate msgDrop;
    private final Subscription subscription;

    public NonPersistentDispatcherSingleActiveConsumer(PulsarApi.CommandSubscribe.SubType subscriptionType, int partitionIndex, NonPersistentTopic topic, Subscription subscription) {
        super(subscriptionType, partitionIndex, topic.getName());
        this.subscription = subscription;
        this.msgDrop = new Rate();
    }

    @Override
    public void sendMessages(List<Entry> entries) {
        Consumer currentConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
        if (currentConsumer != null && currentConsumer.getAvailablePermits() > 0 && currentConsumer.isWritable()) {
            currentConsumer.sendMessages(entries);
        } else {
            entries.forEach(entry -> {
                int totalMsgs = Consumer.getBatchSizeforEntry(entry.getDataBuffer(), this.subscription, -1L);
                if (totalMsgs > 0) {
                    this.msgDrop.recordEvent();
                }
                entry.release();
            });
        }
    }

    @Override
    public Rate getMesssageDropRate() {
        return this.msgDrop;
    }

    @Override
    public boolean hasPermits() {
        return AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this) != null && AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this).getAvailablePermits() > 0;
    }

    @Override
    public void consumerFlow(Consumer consumer, int additionalNumberOfMessages) {
    }

    @Override
    protected void scheduleReadOnActiveConsumer() {
    }

    @Override
    protected void readMoreEntries(Consumer consumer) {
    }

    @Override
    protected void cancelPendingRead() {
    }
}

