/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.metrics.JvmMetrics;
import org.apache.pulsar.broker.stats.metrics.ManagedLedgerCacheMetrics;
import org.apache.pulsar.broker.stats.metrics.ManagedLedgerMetrics;
import org.apache.pulsar.common.stats.Metrics;

public class MetricsGenerator {
    private final PulsarService pulsar;
    private final JvmMetrics jvmMetrics;

    public MetricsGenerator(PulsarService pulsar) {
        this.pulsar = pulsar;
        this.jvmMetrics = new JvmMetrics(pulsar);
    }

    public Collection<Metrics> generate() {
        return this.merge(this.collect());
    }

    private List<Metrics> collect() {
        ArrayList<Metrics> metricsCollection = new ArrayList<Metrics>();
        metricsCollection.addAll(this.jvmMetrics.generate());
        metricsCollection.addAll(new ManagedLedgerCacheMetrics(this.pulsar).generate());
        metricsCollection.addAll(new ManagedLedgerMetrics(this.pulsar).generate());
        metricsCollection.addAll(this.pulsar.getBrokerService().getDestinationMetrics());
        metricsCollection.addAll(this.pulsar.getLoadManager().get().getLoadBalancingMetrics());
        return metricsCollection;
    }

    private Collection<Metrics> merge(List<Metrics> metricsCollection) {
        HashMap mergedMetrics = Maps.newHashMap();
        for (Metrics metrics : metricsCollection) {
            Map dimensionKey = metrics.getDimensions();
            if (!mergedMetrics.containsKey(dimensionKey)) {
                mergedMetrics.put(dimensionKey, metrics);
                continue;
            }
            ((Metrics)mergedMetrics.get(dimensionKey)).putAll(metrics.getMetrics());
        }
        return mergedMetrics.values();
    }
}

