/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.impl.RawMessageImpl;
import org.apache.pulsar.common.api.Commands;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawBatchConverter {
    private static final Logger log = LoggerFactory.getLogger(RawBatchConverter.class);

    private static PulsarApi.MessageMetadata mergeMetadata(PulsarApi.MessageMetadata batchMetadata, PulsarApi.SingleMessageMetadata.Builder singleMessageMetadata) {
        return batchMetadata.toBuilder().setNumMessagesInBatch(1).setUncompressedSize(singleMessageMetadata.getPayloadSize()).addAllProperties((Iterable)singleMessageMetadata.getPropertiesList()).setPartitionKey(singleMessageMetadata.getPartitionKey()).build();
    }

    public static boolean isBatch(RawMessage msg) {
        ByteBuf payload = msg.getHeadersAndPayload();
        PulsarApi.MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)payload);
        int batchSize = metadata.getNumMessagesInBatch();
        return batchSize > 0;
    }

    public static Collection<RawMessage> explodeBatch(RawMessage msg) throws IOException {
        assert (msg.getMessageIdData().getBatchIndex() == -1);
        ByteBuf payload = msg.getHeadersAndPayload();
        PulsarApi.MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)payload);
        int batchSize = metadata.getNumMessagesInBatch();
        ArrayList<RawMessage> exploded = new ArrayList<RawMessage>();
        int i = 0;
        while (i < batchSize) {
            PulsarApi.SingleMessageMetadata.Builder singleMessageMetadataBuilder = PulsarApi.SingleMessageMetadata.newBuilder();
            ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch((ByteBuf)payload, (PulsarApi.SingleMessageMetadata.Builder)singleMessageMetadataBuilder, (int)0, (int)batchSize);
            ByteBuf metadataAndPayload = Commands.serializeMetadataAndPayload((Commands.ChecksumType)Commands.ChecksumType.Crc32c, (PulsarApi.MessageMetadata)RawBatchConverter.mergeMetadata(metadata, singleMessageMetadataBuilder), (ByteBuf)singleMessagePayload);
            exploded.add(new RawMessageImpl(msg.getMessageIdData().toBuilder().setBatchIndex(i).build(), metadataAndPayload));
            metadataAndPayload.release();
            singleMessagePayload.release();
            ++i;
        }
        return exploded;
    }
}

