/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarClusterMetadataSetup {
    private static final Logger log = LoggerFactory.getLogger(PulsarClusterMetadataSetup.class);

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)arguments);
            jcommander.parse(args);
            if (arguments.help) {
                jcommander.usage();
                return;
            }
        }
        catch (Exception exception) {
            jcommander.usage();
            return;
        }
        log.info("Setting up cluster {} with zk={} global-zk={}", new Object[]{arguments.cluster, arguments.zookeeper, arguments.globalZookeeper});
        ClientConfiguration bkConf = new ClientConfiguration();
        bkConf.setLedgerManagerFactoryClass(HierarchicalLedgerManagerFactory.class);
        bkConf.setZkServers(arguments.zookeeper);
        if (!BookKeeperAdmin.format((ClientConfiguration)bkConf, (boolean)false, (boolean)false)) {
            throw new IOException("Failed to initialize BookKeeper metadata");
        }
        ZookeeperClientFactoryImpl zkfactory = new ZookeeperClientFactoryImpl();
        ZooKeeper localZk = (ZooKeeper)zkfactory.create(arguments.zookeeper, ZooKeeperClientFactory.SessionType.ReadWrite, 30000).get();
        ZooKeeper globalZk = (ZooKeeper)zkfactory.create(arguments.globalZookeeper, ZooKeeperClientFactory.SessionType.ReadWrite, 30000).get();
        localZk.create("/managed-ledgers", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        localZk.create("/namespace", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            ZkUtils.createFullPathOptimistic((ZooKeeper)globalZk, (String)"/admin/policies", (byte[])new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {}
        try {
            ZkUtils.createFullPathOptimistic((ZooKeeper)globalZk, (String)"/admin/clusters", (byte[])new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {}
        ClusterData clusterData = new ClusterData(arguments.clusterWebServiceUrl, arguments.clusterWebServiceUrlTls, arguments.clusterBrokerServiceUrl, arguments.clusterBrokerServiceUrlTls);
        byte[] clusterDataJson = ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)clusterData);
        globalZk.create("/admin/clusters/" + arguments.cluster, clusterDataJson, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ClusterData globalClusterData = new ClusterData(null, null);
        byte[] globalClusterDataJson = ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)globalClusterData);
        try {
            globalZk.create("/admin/clusters/global", globalClusterDataJson, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {}
        log.info("Cluster metadata for '{}' setup correctly", (Object)arguments.cluster);
    }

    private static class Arguments {
        @Parameter(names={"-c", "--cluster"}, description="Cluster name", required=true)
        private String cluster;
        @Parameter(names={"-uw", "--web-service-url"}, description="Web-service URL for new cluster", required=true)
        private String clusterWebServiceUrl;
        @Parameter(names={"-tw", "--web-service-url-tls"}, description="Web-service URL for new cluster with TLS encryption", required=false)
        private String clusterWebServiceUrlTls;
        @Parameter(names={"-ub", "--broker-service-url"}, description="Broker-service URL for new cluster", required=false)
        private String clusterBrokerServiceUrl;
        @Parameter(names={"-tb", "--broker-service-url-tls"}, description="Broker-service URL for new cluster with TLS encryption", required=false)
        private String clusterBrokerServiceUrlTls;
        @Parameter(names={"-zk", "--zookeeper"}, description="Local ZooKeeper quorum connection string", required=true)
        private String zookeeper;
        @Parameter(names={"-gzk", "--global-zookeeper"}, description="Global ZooKeeper quorum connection string", required=true)
        private String globalZookeeper;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;

        private Arguments() {
        }
    }
}

